/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.generator.simple.time;

import io.goodforgod.dummymaker.generator.Generator;
import io.goodforgod.dummymaker.util.RandomUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class LocalDateTimeGenerator
implements Generator<LocalDateTime> {
    private static final Pattern PATTERN = Pattern.compile("datetime|stamp|timestamp|expired?", 2);
    private final long from;
    private final long to;

    public LocalDateTimeGenerator() {
        this(0L, 4102358400L);
    }

    public LocalDateTimeGenerator(long from, long to) {
        this.from = from;
        this.to = to;
    }

    @Override
    @NotNull
    public LocalDateTime get() {
        long usedFrom = this.from;
        long usedTo = this.to;
        if (usedFrom < 0L) {
            usedFrom = 0L;
        }
        if (usedTo > 4102358400L) {
            usedTo = 4102358400L;
        }
        long amount = usedTo < usedFrom ? usedFrom : RandomUtils.random(usedFrom, usedTo);
        return LocalDateTime.ofEpochSecond(amount, 0, ZoneOffset.UTC);
    }

    @Override
    @NotNull
    public Generator.Hints hints() {
        return Generator.Hints.builder().withPattern(PATTERN).withPriority(60).build();
    }
}

