/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.util;

import io.goodforgod.dummymaker.generator.Generator;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class CastUtils {
    private CastUtils() {
    }

    public static Object castToNumber(Object value, Class<?> fieldType) {
        try {
            CastType castType = CastType.of(fieldType);
            switch (castType) {
                case BYTE: {
                    return Byte.valueOf(String.valueOf(value));
                }
                case SHORT: {
                    long shortTemp = Long.parseLong(String.valueOf(value));
                    if (shortTemp > 32767L) {
                        return (short)Short.MAX_VALUE;
                    }
                    if (shortTemp < -32768L) {
                        return (short)Short.MIN_VALUE;
                    }
                    return (short)shortTemp;
                }
                case INT: {
                    long intTemp = Long.parseLong(String.valueOf(value));
                    if (intTemp > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    if (intTemp < Integer.MIN_VALUE) {
                        return Integer.MIN_VALUE;
                    }
                    return (int)intTemp;
                }
                case LONG: {
                    return Long.valueOf(String.valueOf(value));
                }
                case FLOAT: {
                    return Float.valueOf(String.valueOf(value));
                }
                case DOUBLE: {
                    return Double.valueOf(String.valueOf(value));
                }
                case BIG_INT: {
                    return new BigInteger(String.valueOf(value));
                }
                case BIG_DECIMAL: {
                    return new BigDecimal(String.valueOf(value));
                }
                case CHAR: {
                    try {
                        return Character.valueOf(Character.forDigit(Integer.parseInt(String.valueOf(value)), 10));
                    }
                    catch (Exception e) {
                        return Character.valueOf(String.valueOf(value).charAt(0));
                    }
                }
                case BOOLEAN: {
                    String b = String.valueOf(value);
                    if ("1".equals(b)) {
                        return true;
                    }
                    if ("0".equals(b)) {
                        return false;
                    }
                    return Boolean.valueOf(String.valueOf(value));
                }
            }
            return value;
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public static <T> T instantiate(Class<T> tClass, T defaultEntity) {
        T t = CastUtils.instantiate(tClass);
        return t == null ? defaultEntity : t;
    }

    public static <T> T instantiate(Class<T> target) {
        if (target == null) {
            return null;
        }
        Constructor constructor = Arrays.stream(target.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).findFirst().orElse(Arrays.stream(target.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 1).findFirst().orElse(null));
        try {
            if (constructor == null) {
                throw new IllegalStateException("Can not instantiate '" + target.getCanonicalName() + "', zero argument constructor not found");
            }
            constructor.setAccessible(true);
            if (constructor.getParameterTypes().length > 0) {
                Class<?> parentType = constructor.getParameterTypes()[0];
                if (!CastType.of(parentType).equals((Object)CastType.UNKNOWN)) {
                    throw new IllegalStateException("Can not instantiate '" + target.getCanonicalName() + "', zero argument constructor not found");
                }
                Object parent = CastUtils.instantiate(parentType);
                if (parent == null) {
                    return null;
                }
                return constructor.newInstance(parent);
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T generateObject(Generator generator, Class<T> fieldType) {
        if (generator == null) {
            return null;
        }
        Object object = generator.get();
        return CastUtils.castObject(object, fieldType);
    }

    public static Type getGenericType(Type type) {
        return CastUtils.getGenericType(type, 0);
    }

    public static Type getGenericType(Type type, int paramNumber) {
        try {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments().length < paramNumber + 1 ? Object.class : parameterizedType.getActualTypeArguments()[paramNumber];
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    public static <T> T castObject(Object castObject, Class<T> fieldType) {
        boolean isTypeString;
        if (fieldType == null) {
            return null;
        }
        boolean bl = isTypeString = String.class.equals(fieldType) || CharSequence.class.isAssignableFrom(fieldType);
        if (castObject == null) {
            return (T)(isTypeString ? "null" : null);
        }
        Class<?> castType = castObject.getClass();
        boolean isTypeAssignable = fieldType.isAssignableFrom(castType);
        boolean isTypeEquals = CastUtils.areEquals(castType, fieldType);
        boolean isTypeObject = fieldType.equals(Object.class);
        Object boxedIfPossible = CastUtils.boxObject(castObject, fieldType);
        return CastUtils.castObject(boxedIfPossible, fieldType, isTypeAssignable, isTypeEquals, isTypeObject, isTypeString);
    }

    private static <T> Object boxObject(Object castObject, Class<T> fieldType) {
        CastType firstType = CastType.of(castObject.getClass());
        CastType secondType = CastType.of(fieldType);
        return secondType.equals((Object)CastType.UNKNOWN) || firstType.equals((Object)CastType.UNKNOWN) ? castObject : CastUtils.castToNumber(castObject, fieldType);
    }

    private static boolean areEquals(Class<?> firstClass, Class<?> secondClass) {
        CastType firstType = CastType.of(firstClass);
        CastType secondType = CastType.of(secondClass);
        return firstType.equals((Object)CastType.UNKNOWN) || secondType.equals((Object)CastType.UNKNOWN) ? firstClass.equals(secondClass) : firstType.equals((Object)secondType);
    }

    private static <T> T castObject(Object castObject, Class<T> fieldType, boolean isTypeAssignable, boolean isTypeEquals, boolean isTypeObject, boolean isTypeString) {
        if (isTypeEquals || isTypeObject) {
            return (T)castObject;
        }
        if (isTypeString) {
            return (T)String.valueOf(castObject);
        }
        if (isTypeAssignable) {
            return fieldType.cast(castObject);
        }
        Optional<Class<?>> analog = CastUtils.getPrimitiveOrBoxedAnalog(fieldType);
        if (analog.isPresent()) {
            try {
                Object result = analog.get().cast(castObject);
                if (result != null) {
                    return (T)result;
                }
            }
            catch (Exception result) {
                // empty catch block
            }
        }
        try {
            return fieldType.cast(castObject);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isPrimitive(@NotNull Class<?> type) {
        return type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Byte.TYPE) || type.isAssignableFrom(Short.TYPE) || type.isAssignableFrom(Character.TYPE) || type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Float.TYPE) || type.isAssignableFrom(Double.TYPE);
    }

    public static Optional<Class<?>> getPrimitiveOrBoxedAnalog(@NotNull Class<?> type) {
        if (Boolean.class.isAssignableFrom(type)) {
            return Optional.of(Boolean.TYPE);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            return Optional.of(Boolean.class);
        }
        if (Byte.class.isAssignableFrom(type)) {
            return Optional.of(Byte.TYPE);
        }
        if (Byte.TYPE.isAssignableFrom(type)) {
            return Optional.of(Byte.class);
        }
        if (Short.class.isAssignableFrom(type)) {
            return Optional.of(Short.TYPE);
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return Optional.of(Short.class);
        }
        if (Character.class.isAssignableFrom(type)) {
            return Optional.of(Character.TYPE);
        }
        if (Character.TYPE.isAssignableFrom(type)) {
            return Optional.of(Character.class);
        }
        if (Integer.class.isAssignableFrom(type)) {
            return Optional.of(Integer.TYPE);
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return Optional.of(Integer.class);
        }
        if (Long.class.isAssignableFrom(type)) {
            return Optional.of(Long.TYPE);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return Optional.of(Long.class);
        }
        if (Float.class.isAssignableFrom(type)) {
            return Optional.of(Float.TYPE);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return Optional.of(Float.class);
        }
        if (Double.class.isAssignableFrom(type)) {
            return Optional.of(Double.TYPE);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return Optional.of(Double.class);
        }
        return Optional.empty();
    }

    public static enum CastType {
        UNKNOWN,
        STRING,
        BOOLEAN,
        BYTE,
        SHORT,
        CHAR,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BIG_INT,
        BIG_DECIMAL;


        public static CastType of(Class<?> type) {
            if (String.class.isAssignableFrom(type) || CharSequence.class.isAssignableFrom(type)) {
                return STRING;
            }
            if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                return BOOLEAN;
            }
            if (type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Byte.TYPE)) {
                return BYTE;
            }
            if (type.isAssignableFrom(Short.class) || type.isAssignableFrom(Short.TYPE)) {
                return SHORT;
            }
            if (type.isAssignableFrom(Character.class) || type.isAssignableFrom(Character.TYPE)) {
                return CHAR;
            }
            if (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE)) {
                return INT;
            }
            if (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE)) {
                return LONG;
            }
            if (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE)) {
                return FLOAT;
            }
            if (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE)) {
                return DOUBLE;
            }
            if (BigInteger.class.isAssignableFrom(type)) {
                return BIG_INT;
            }
            if (BigDecimal.class.isAssignableFrom(type)) {
                return BIG_DECIMAL;
            }
            return UNKNOWN;
        }
    }
}

