/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.dummymaker.util;

import io.goodforgod.dummymaker.util.RandomUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !CollectionUtils.isEmpty(array);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtils.isEmpty(map);
    }

    public static <T> T getIndexWithSalt(List<T> list, String name, long salt) {
        return list.get(CollectionUtils.getIndexWithSalt(list.size(), name, salt));
    }

    public static int getIndexWithSalt(int size, String name, long salt) {
        int counter = 0;
        for (char c : name.toCharArray()) {
            counter += c;
        }
        long shift = (long)counter + salt;
        return Long.valueOf(Math.abs(shift % (long)size)).intValue();
    }

    public static <T> T random(@NotNull T[] array) {
        return array.length == 0 ? null : (T)array[RandomUtils.random(array.length - 1)];
    }

    public static <T> T random(@NotNull Collection<T> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        int random = RandomUtils.random(collection.size() - 1);
        if (collection instanceof List) {
            return (T)((List)collection).get(random);
        }
        Iterator<T> iterator = collection.iterator();
        for (int i = 0; i < random; ++i) {
            iterator.next();
        }
        return iterator.next();
    }
}

