/*
 * Decompiled with CFR 0.152.
 */
package com.github.gotson.nightmonkeys.heif;

import com.github.gotson.nightmonkeys.common.imageio.IIOUtil;
import com.github.gotson.nightmonkeys.heif.BasicInfo;
import com.github.gotson.nightmonkeys.heif.HeifException;
import com.github.gotson.nightmonkeys.heif.lib.HeifError;
import com.github.gotson.nightmonkeys.heif.lib.enums.HeifChroma;
import com.github.gotson.nightmonkeys.heif.lib.enums.HeifColorSpace;
import com.github.gotson.nightmonkeys.heif.lib.enums.HeifErrorCode;
import com.github.gotson.nightmonkeys.heif.lib.enums.HeifFiletypeResult;
import com.github.gotson.nightmonkeys.heif.lib.panama.heif_h;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteOrder;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Heif {
    private static final Logger LOGGER = LoggerFactory.getLogger(Heif.class);
    private static final ValueLayout.OfInt pixelLayout = heif_h.C_INT.withOrder(ByteOrder.BIG_ENDIAN);

    public static boolean isLibVersionSupported() {
        int versionBcd = heif_h.heif_get_version_number();
        int major = versionBcd >> 24 & 0xFF;
        int minor = versionBcd >> 16 & 0xFF;
        if (major != 1) {
            return false;
        }
        return minor >= 16;
    }

    public static String getLibVersion() {
        return heif_h.heif_get_version().getString(0L);
    }

    public static boolean canDecode(ImageInputStream stream) throws HeifException {
        Arena arena = Arena.ofConfined();
        try {
            boolean bl;
            stream.mark();
            int len = 12;
            byte[] heifData = new byte[len];
            stream.read(heifData);
            stream.reset();
            MemorySegment data = arena.allocate(heifData.length);
            data.copyFrom(MemorySegment.ofArray(heifData));
            HeifFiletypeResult result = HeifFiletypeResult.fromId(heif_h.heif_check_filetype(data, len));
            boolean bl2 = bl = result == HeifFiletypeResult.HEIF_FILETYPE_YES_SUPPORTED || result == HeifFiletypeResult.HEIF_FILETYPE_YES_UNSUPPORTED || result == HeifFiletypeResult.HEIF_FILETYPE_MAYBE;
            if (arena != null) {
                arena.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new HeifException("Couldn't get stream content", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static BasicInfo getBasicInfo(ImageInputStream stream) throws HeifException {
        try (Arena arena = Arena.ofConfined();){
            BasicInfo basicInfo;
            MemorySegment handle;
            block14: {
                stream.mark();
                byte[] heifData = IIOUtil.byteArrayFromStream((ImageInputStream)stream);
                stream.reset();
                MemorySegment data = arena.allocate(heifData.length);
                data.copyFrom(MemorySegment.ofArray(heifData));
                MemorySegment heifContext = null;
                handle = null;
                try {
                    heif_h.heif_init(arena, MemorySegment.NULL);
                    heifContext = heif_h.heif_context_alloc();
                    Heif.checkError(heif_h.heif_context_read_from_memory_without_copy(arena, heifContext, data, heifData.length, MemorySegment.NULL));
                    int frameCount = heif_h.heif_context_get_number_of_top_level_images(heifContext);
                    MemorySegment handlePtr = arena.allocate(heif_h.C_POINTER);
                    Heif.checkError(heif_h.heif_context_get_primary_image_handle(arena, heifContext, handlePtr));
                    handle = handlePtr.get(heif_h.C_POINTER, 0L);
                    int width = heif_h.heif_image_handle_get_width(handle);
                    int height = heif_h.heif_image_handle_get_height(handle);
                    boolean hasAlpha = heif_h.heif_image_handle_has_alpha_channel(handle) > 0;
                    basicInfo = new BasicInfo(width, height, hasAlpha, null, frameCount);
                    if (heifContext == null) break block14;
                }
                catch (Throwable throwable) {
                    if (heifContext != null) {
                        heif_h.heif_context_free(heifContext);
                    }
                    if (handle != null) {
                        heif_h.heif_image_handle_release(handle);
                    }
                    heif_h.heif_deinit();
                    throw throwable;
                }
                heif_h.heif_context_free(heifContext);
            }
            if (handle != null) {
                heif_h.heif_image_handle_release(handle);
            }
            heif_h.heif_deinit();
            return basicInfo;
        }
        catch (IOException e) {
            throw new HeifException("Couldn't get stream content", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode(ImageInputStream stream, BasicInfo info, WritableRaster raster, ImageReadParam param, int imageIndex) throws HeifException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment handle;
            MemorySegment heifContext;
            block20: {
                stream.mark();
                byte[] heifData = IIOUtil.byteArrayFromStream((ImageInputStream)stream);
                stream.reset();
                MemorySegment data = arena.allocate(heifData.length);
                data.copyFrom(MemorySegment.ofArray(heifData));
                heifContext = null;
                handle = null;
                MemorySegment image = null;
                try {
                    Rectangle sourceRegion;
                    heif_h.heif_init(arena, MemorySegment.NULL);
                    heifContext = heif_h.heif_context_alloc();
                    Heif.checkError(heif_h.heif_context_read_from_memory_without_copy(arena, heifContext, data, heifData.length, MemorySegment.NULL));
                    MemorySegment imageIds = arena.allocate(heif_h.C_INT, info.frameCount());
                    heif_h.heif_context_get_list_of_top_level_image_IDs(heifContext, imageIds, info.frameCount());
                    int imageId = imageIds.get(heif_h.C_INT, (long)imageIndex * heif_h.C_INT.byteSize());
                    MemorySegment handlePtr = arena.allocate(heif_h.C_POINTER);
                    Heif.checkError(heif_h.heif_context_get_image_handle(arena, heifContext, imageId, handlePtr));
                    handle = handlePtr.get(heif_h.C_POINTER, 0L);
                    int width = heif_h.heif_image_handle_get_width(handle);
                    int height = heif_h.heif_image_handle_get_height(handle);
                    MemorySegment imagePtr = arena.allocate(heif_h.C_POINTER);
                    Heif.checkError(heif_h.heif_decode_image(arena, handle, imagePtr, HeifColorSpace.HEIF_COLOR_SPACE_RGB.intValue(), HeifChroma.HEIF_CHROMA_INTERLEAVED_RGBA.intValue(), MemorySegment.NULL));
                    image = imagePtr.get(heif_h.C_POINTER, 0L);
                    MemorySegment stridePtr = arena.allocate(heif_h.C_INT);
                    MemorySegment pixels = heif_h.heif_image_get_plane_readonly(image, heif_h.heif_channel_interleaved(), stridePtr);
                    int stride = stridePtr.get(heif_h.C_INT, 0L);
                    int[] pixelsRaster = new int[Math.min(width, raster.getWidth()) * Math.min(height, raster.getHeight())];
                    Rectangle rectangle = sourceRegion = param != null ? param.getSourceRegion() : null;
                    if (sourceRegion == null) {
                        sourceRegion = new Rectangle(0, 0, width, height);
                    }
                    int ssX = param != null ? param.getSourceXSubsampling() : 1;
                    int ssY = param != null ? param.getSourceYSubsampling() : 1;
                    int ssOffX = param != null ? param.getSubsamplingXOffset() : 0;
                    int ssOffY = param != null ? param.getSubsamplingYOffset() : 0;
                    int offset = 0;
                    for (int row = sourceRegion.y + ssOffY; row < sourceRegion.y + sourceRegion.height && offset < pixelsRaster.length; row += ssY) {
                        for (int col = sourceRegion.x + ssOffX; col < sourceRegion.x + sourceRegion.width && offset < pixelsRaster.length; col += ssX) {
                            int pixel = pixels.get(pixelLayout, (long)row * (long)stride + (long)col * pixelLayout.byteSize());
                            pixelsRaster[offset++] = pixel;
                        }
                    }
                    if (param != null && param.getDestinationOffset() != null) {
                        raster.setDataElements(param.getDestinationOffset().x, param.getDestinationOffset().y, raster.getWidth() - param.getDestinationOffset().x, raster.getHeight() - param.getDestinationOffset().y, pixelsRaster);
                    } else {
                        raster.setDataElements(0, 0, raster.getWidth(), raster.getHeight(), pixelsRaster);
                    }
                    if (image == null) break block20;
                }
                catch (Throwable throwable) {
                    if (image != null) {
                        heif_h.heif_image_release(image);
                    }
                    if (heifContext != null) {
                        heif_h.heif_context_free(heifContext);
                    }
                    if (handle != null) {
                        heif_h.heif_image_handle_release(handle);
                    }
                    heif_h.heif_deinit();
                    throw throwable;
                }
                heif_h.heif_image_release(image);
            }
            if (heifContext != null) {
                heif_h.heif_context_free(heifContext);
            }
            if (handle != null) {
                heif_h.heif_image_handle_release(handle);
            }
            heif_h.heif_deinit();
        }
        catch (IOException e) {
            throw new HeifException("Couldn't get stream content", e);
        }
    }

    private static void checkError(MemorySegment segment) throws HeifException {
        Heif.check(HeifError.from(segment));
    }

    private static void check(HeifError error) throws HeifException {
        if (error.code() != HeifErrorCode.HEIF_ERROR_OK) {
            throw new HeifException(error.message());
        }
    }
}

