/*
 * Decompiled with CFR 0.152.
 */
package com.github.gotson.nightmonkeys.heif.imageio.plugins;

import com.github.gotson.nightmonkeys.heif.BasicInfo;
import com.github.gotson.nightmonkeys.heif.Heif;
import com.github.gotson.nightmonkeys.heif.HeifException;
import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.color.ColorProfiles;
import com.twelvemonkeys.imageio.color.ColorSpaces;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HeifImageReader
extends ImageReaderBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeifImageReader.class);
    private BasicInfo info;
    private List<ImageTypeSpecifier> imageTypes;

    protected HeifImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    private void readInfo() throws IOException {
        if (this.info == null) {
            try {
                this.info = Heif.getBasicInfo((ImageInputStream)this.input);
                ColorSpace colorSpace = this.info.iccProfile() != null ? ColorSpaces.createColorSpace((ICC_Profile)this.info.iccProfile()) : ColorSpace.getInstance(1000);
                this.imageTypes = List.of(ImageTypeSpecifiers.createPacked((ColorSpace)colorSpace, (int)-16777216, (int)0xFF0000, (int)65280, (int)255, (int)3, (boolean)false));
            }
            catch (HeifException e) {
                throw new IOException(e);
            }
        }
    }

    private void readInfo(int imageIndex) throws IOException {
        this.checkBounds(imageIndex);
        this.readInfo();
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        this.assertInput();
        this.readInfo();
        return this.info.frameCount();
    }

    public int getWidth(int imageIndex) throws IOException {
        this.readInfo(imageIndex);
        return this.info.width();
    }

    public int getHeight(int imageIndex) throws IOException {
        this.readInfo(imageIndex);
        return this.info.height();
    }

    public ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        this.readInfo(imageIndex);
        return this.imageTypes.get(0);
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readInfo(imageIndex);
        return this.imageTypes.iterator();
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.readInfo(imageIndex);
        int width = this.getWidth(imageIndex);
        int height = this.getHeight(imageIndex);
        BufferedImage destination = HeifImageReader.getDestination((ImageReadParam)param, this.getImageTypes(imageIndex), (int)width, (int)height);
        this.processImageStarted(imageIndex);
        this.processImageProgress(0.0f);
        try {
            Heif.decode((ImageInputStream)this.getInput(), this.info, destination.getRaster(), param, imageIndex);
        }
        catch (HeifException e) {
            throw new IOException(e);
        }
        this.applyICCProfileIfNeeded(destination);
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return destination;
    }

    public IIOMetadata getStreamMetadata() {
        return null;
    }

    public IIOMetadata getImageMetadata(int imageIndex) {
        return null;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.info = null;
        this.imageTypes = null;
        super.setInput(input, seekForwardOnly, ignoreMetadata);
    }

    protected void resetMembers() {
        this.info = null;
        this.imageTypes = null;
    }

    private void applyICCProfileIfNeeded(BufferedImage destination) {
        if (this.info.iccProfile() != null) {
            ColorModel colorModel = destination.getColorModel();
            ICC_Profile destinationProfile = ((ICC_ColorSpace)colorModel.getColorSpace()).getProfile();
            if (!this.info.iccProfile().equals(destinationProfile)) {
                LOGGER.debug("Converting from " + String.valueOf(this.info.iccProfile()) + " to " + String.valueOf(ColorProfiles.isCS_sRGB((ICC_Profile)destinationProfile) ? "sRGB" : destinationProfile));
                WritableRaster raster = colorModel.hasAlpha() ? destination.getRaster().createWritableChild(0, 0, destination.getWidth(), destination.getHeight(), 0, 0, new int[]{0, 1, 2}) : destination.getRaster();
                new ColorConvertOp(new ICC_Profile[]{this.info.iccProfile(), destinationProfile}, null).filter(raster, raster);
            }
        }
    }
}

