/*
 * Decompiled with CFR 0.152.
 */
package com.github.gotson.nightmonkeys.heif.imageio.plugins;

import com.github.gotson.nightmonkeys.heif.Heif;
import com.github.gotson.nightmonkeys.heif.HeifException;
import com.github.gotson.nightmonkeys.heif.imageio.plugins.HeifImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HeifImageReaderSpi
extends ImageReaderSpi {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeifImageReaderSpi.class);
    private static final String vendorName = "NightMonkeys";
    private static final String version = "0.1.0";
    private static final String readerClassName = "com.github.gotson.nightmonkeys.heif.imageio.plugins.HeifImageReader";
    private static final String[] names = new String[]{"AVIF", "HEIF", "HEIC"};
    private static final String[] suffixes = new String[]{"heif", "heifs", "heic", "heics", "avci", "avcs", "avif", "HIF"};
    private static final String[] MIMETypes = new String[]{"image/avif", "image/heif", "image/heif-sequence", "image/heic", "image/heic-sequence"};
    private static final String[] writerSpiNames = null;
    private boolean libLoaded = false;

    public HeifImageReaderSpi() {
        super(vendorName, version, names, suffixes, MIMETypes, readerClassName, new Class[]{ImageInputStream.class}, writerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    private boolean loadLibrary() {
        if (!this.libLoaded) {
            try {
                LOGGER.info("Loaded libheif v{}", (Object)Heif.getLibVersion());
                if (Heif.isLibVersionSupported()) {
                    this.libLoaded = true;
                } else {
                    LOGGER.warn("libheif version is not supported");
                }
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.warn("Could not load libheif, plugin will be disabled. {}", (Object)e.getMessage());
            }
            catch (ExceptionInInitializerError e) {
                LOGGER.warn("Native access is disabled, plugin will be disabled. Try adding JVM arguments: --enable-native-access=ALL-UNNAMED");
            }
            catch (Exception e) {
                LOGGER.warn("Unknown error", (Throwable)e);
            }
        }
        return this.libLoaded;
    }

    @Override
    public void onRegistration(ServiceRegistry registry, Class<?> category) {
        if (!this.loadLibrary()) {
            LOGGER.info("Deregistering service provider");
            registry.deregisterServiceProvider(this);
        }
        super.onRegistration(registry, category);
    }

    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        if (!(input instanceof ImageInputStream)) {
            input = ImageIO.createImageInputStream(input);
        }
        if (input == null) {
            return false;
        }
        try {
            return Heif.canDecode((ImageInputStream)input);
        }
        catch (HeifException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        return new HeifImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Avif/Heif reader plugin based on libheif.";
    }
}

