/*
 * Decompiled with CFR 0.152.
 */
package com.gp89developers.calculatorinputview.activities;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.gp89developers.calculatorinputview.R;
import com.gp89developers.calculatorinputview.widget.NumericEditText;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class CalculatorActivity
extends AppCompatActivity {
    public static final int NUMBER_EDIT_TEXT_MAX_LENGTH = 30;
    public static final int REQUEST_RESULT_SUCCESSFUL = 2;
    public static final String TITLE_ACTIVITY = "title_activity";
    public static final String VALUE = "value_calculator";
    public static final String RESULT = "result_calculator";
    public static final String ZERO = "0";
    public static final String ZERO_ZERO = "00";
    public static final String POINT = ".";
    public static final String CLICK_ARITHMETIC_OPERATOR = "clickArithmeticOperator";
    public static final String CLEAR_INPUT = "clearInput";
    public static final String FIRST_VALUE = "firstValue";
    public static final String SECONDS_VALUE = "secondsValue";
    public static final String OPERATOR_EXECUTE = "operatorExecute";
    public static final String PREV_OPERATOR_EXECUTE = "prevOperatorExecute";
    private DecimalFormat decimalFormat;
    private NumericEditText inputNumberText;
    private TextView developmentOperationInputText;
    private Button equalBtn;
    private Button submitBtn;
    private boolean clickArithmeticOperator;
    private boolean clearInput;
    private final View.OnClickListener mOnNumberBtnClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (view instanceof Button) {
                String value = ((Button)view).getText().toString();
                CalculatorActivity.this.concatNumeric(value);
                CalculatorActivity.this.clickArithmeticOperator = false;
            }
        }
    };
    private Double firstValue;
    private Double secondsValue;
    private String operatorExecute = "none";
    private String prevOperatorExecute = "none";
    private final View.OnClickListener mOnOperatorBtnClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (view instanceof Button) {
                String value;
                switch (value = ((Button)view).getText().toString()) {
                    case "+": 
                    case "-": 
                    case "x": 
                    case "\u00f7": {
                        if (TextUtils.isEmpty((CharSequence)CalculatorActivity.this.inputNumberText.getText()) || CalculatorActivity.this.inputNumberText.getText().toString().equals(CalculatorActivity.POINT)) {
                            return;
                        }
                        CalculatorActivity.this.equalBtn.setVisibility(0);
                        CalculatorActivity.this.submitBtn.setVisibility(8);
                        CalculatorActivity.this.operatorExecute = value;
                        if (!CalculatorActivity.this.clickArithmeticOperator) {
                            CalculatorActivity.this.clickArithmeticOperator = true;
                            CalculatorActivity.this.prepareOperation(false);
                            break;
                        }
                        CalculatorActivity.this.replaceOperator(value);
                        break;
                    }
                    case "C": {
                        CalculatorActivity.this.clear();
                        break;
                    }
                    case "DEL": {
                        CalculatorActivity.this.removeLastNumber();
                        break;
                    }
                    case "=": 
                    case "DONE": {
                        if (CalculatorActivity.this.inputNumberText.getText().toString().equals(CalculatorActivity.POINT)) {
                            String temp = CalculatorActivity.this.developmentOperationInputText.getText().toString();
                            CalculatorActivity.this.clear();
                            CalculatorActivity.this.inputNumberText.setText(temp);
                            return;
                        }
                        if (CalculatorActivity.this.operatorExecute.equals("DONE") || CalculatorActivity.this.firstValue == null) {
                            CalculatorActivity.this.returnResultOperation();
                            break;
                        }
                        CalculatorActivity.this.prepareOperation(true);
                        CalculatorActivity.this.clearInput = false;
                        CalculatorActivity.this.clickArithmeticOperator = false;
                        CalculatorActivity.this.operatorExecute = "DONE";
                        CalculatorActivity.this.prevOperatorExecute = "none";
                        CalculatorActivity.this.firstValue = null;
                        CalculatorActivity.this.secondsValue = null;
                    }
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_calculator);
        this.setupActionBar();
        this.initComponents();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putBoolean(CLICK_ARITHMETIC_OPERATOR, this.clickArithmeticOperator);
            outState.putBoolean(CLEAR_INPUT, this.clearInput);
            if (this.firstValue != null) {
                outState.putDouble(FIRST_VALUE, this.firstValue.doubleValue());
            }
            if (this.secondsValue != null) {
                outState.putDouble(SECONDS_VALUE, this.secondsValue.doubleValue());
            }
            outState.putString(OPERATOR_EXECUTE, this.operatorExecute);
            outState.putString(PREV_OPERATOR_EXECUTE, this.prevOperatorExecute);
        }
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (savedInstanceState != null) {
            this.clickArithmeticOperator = savedInstanceState.getBoolean(CLICK_ARITHMETIC_OPERATOR);
            this.clearInput = savedInstanceState.getBoolean(CLEAR_INPUT);
            if (savedInstanceState.containsKey(FIRST_VALUE)) {
                this.firstValue = savedInstanceState.getDouble(FIRST_VALUE);
            }
            if (savedInstanceState.containsKey(SECONDS_VALUE)) {
                this.secondsValue = savedInstanceState.getDouble(SECONDS_VALUE);
            }
            this.operatorExecute = savedInstanceState.getString(OPERATOR_EXECUTE);
            this.prevOperatorExecute = savedInstanceState.getString(PREV_OPERATOR_EXECUTE);
        }
    }

    public boolean onSupportNavigateUp() {
        this.finish();
        return super.onSupportNavigateUp();
    }

    private void setupActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    private void initComponents() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        this.decimalFormat = new DecimalFormat("#,###,##0.00", decimalFormatSymbols);
        String title = this.getIntent().getStringExtra(TITLE_ACTIVITY);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.setTitle(this.getIntent().getStringExtra(TITLE_ACTIVITY));
        } else {
            this.setTitle(this.getString(R.string.app_name));
        }
        String value = TextUtils.isEmpty((CharSequence)this.getIntent().getStringExtra(VALUE)) ? "" : this.getIntent().getStringExtra(VALUE);
        this.developmentOperationInputText = (TextView)this.findViewById(R.id.developing_operation_inputText);
        this.inputNumberText = (NumericEditText)this.findViewById(R.id.number_inputText);
        this.inputNumberText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(30)});
        this.inputNumberText.setText(value);
        Button clearBtn = (Button)this.findViewById(R.id.clear_button);
        Button deleteBtn = (Button)this.findViewById(R.id.delete_button);
        this.equalBtn = (Button)this.findViewById(R.id.equal_button);
        this.submitBtn = (Button)this.findViewById(R.id.submit_button);
        Button dividerBtn = (Button)this.findViewById(R.id.divider_button);
        Button multiplicationBtn = (Button)this.findViewById(R.id.multiplication_button);
        Button subtractionBtn = (Button)this.findViewById(R.id.subtraction_button);
        Button sumBtn = (Button)this.findViewById(R.id.sum_button);
        Button pointBtn = (Button)this.findViewById(R.id.point_button);
        Button zeroBtn = (Button)this.findViewById(R.id.zero_button);
        Button twoZeroButton = (Button)this.findViewById(R.id.two_zero_button);
        Button oneBtn = (Button)this.findViewById(R.id.one_button);
        Button twoBtn = (Button)this.findViewById(R.id.two_button);
        Button threeBtn = (Button)this.findViewById(R.id.three_button);
        Button fourBtn = (Button)this.findViewById(R.id.four_button);
        Button fiveBtn = (Button)this.findViewById(R.id.five_button);
        Button sixBtn = (Button)this.findViewById(R.id.six_button);
        Button sevenBtn = (Button)this.findViewById(R.id.seven_button);
        Button eightBtn = (Button)this.findViewById(R.id.eight_button);
        Button nineBtn = (Button)this.findViewById(R.id.nine_button);
        ArrayList<Button> arithmeticOperators = new ArrayList<Button>();
        arithmeticOperators.add(dividerBtn);
        arithmeticOperators.add(multiplicationBtn);
        arithmeticOperators.add(subtractionBtn);
        arithmeticOperators.add(sumBtn);
        ArrayList<Button> secondaryOperators = new ArrayList<Button>();
        secondaryOperators.add(clearBtn);
        secondaryOperators.add(deleteBtn);
        secondaryOperators.add(this.equalBtn);
        secondaryOperators.add(this.submitBtn);
        ArrayList<Button> numericOperators = new ArrayList<Button>();
        numericOperators.add(pointBtn);
        numericOperators.add(zeroBtn);
        numericOperators.add(twoZeroButton);
        numericOperators.add(oneBtn);
        numericOperators.add(twoBtn);
        numericOperators.add(threeBtn);
        numericOperators.add(fourBtn);
        numericOperators.add(fiveBtn);
        numericOperators.add(sixBtn);
        numericOperators.add(sevenBtn);
        numericOperators.add(eightBtn);
        numericOperators.add(nineBtn);
        this.setOnClickListenerBtn(arithmeticOperators, this.mOnOperatorBtnClickListener);
        this.setOnClickListenerBtn(secondaryOperators, this.mOnOperatorBtnClickListener);
        this.setOnClickListenerBtn(numericOperators, this.mOnNumberBtnClickListener);
    }

    private void prepareOperation(boolean isEqualExecute) {
        this.clearInput = true;
        if (isEqualExecute) {
            this.equalBtn.setVisibility(8);
            this.submitBtn.setVisibility(0);
            this.developmentOperationInputText.setText((CharSequence)"");
        } else {
            this.concatDevelopingOperation(this.operatorExecute, this.inputNumberText.getText().toString(), false);
        }
        if (this.firstValue == null) {
            this.firstValue = Double.parseDouble(this.inputNumberText.getText().toString().replaceAll(",", ""));
        } else if (this.secondsValue == null) {
            this.secondsValue = Double.parseDouble(this.inputNumberText.getText().toString().replaceAll(",", ""));
            this.executeOperation(this.prevOperatorExecute);
        }
        this.prevOperatorExecute = this.operatorExecute;
    }

    private void executeOperation(String operator) {
        if (this.firstValue == null || this.secondsValue == null) {
            return;
        }
        double resultOperation = 0.0;
        switch (operator) {
            case "+": {
                resultOperation = this.firstValue + this.secondsValue;
                break;
            }
            case "-": {
                resultOperation = this.firstValue - this.secondsValue;
                break;
            }
            case "x": {
                resultOperation = this.firstValue * this.secondsValue;
                break;
            }
            case "\u00f7": {
                if (!(this.secondsValue > 0.0)) break;
                resultOperation = this.firstValue / this.secondsValue;
            }
        }
        this.inputNumberText.setText(this.formatValue(resultOperation));
        this.firstValue = resultOperation;
        this.secondsValue = null;
    }

    private void concatNumeric(String value) {
        if (value == null || this.inputNumberText.getText() == null) {
            return;
        }
        String oldValue = this.inputNumberText.getText().toString();
        String newValue = this.clearInput || oldValue.equals(ZERO) && !value.equals(POINT) ? value : oldValue + value;
        newValue = oldValue.equals(ZERO) && value.equals(ZERO_ZERO) ? oldValue : newValue;
        this.inputNumberText.setText(newValue);
        this.clearInput = false;
    }

    private void concatDevelopingOperation(String operator, String value, boolean clear) {
        boolean noValidCharacter;
        boolean bl = noValidCharacter = operator.equals("C") || operator.equals("DEL") || operator.equals("=");
        if (!noValidCharacter) {
            String oldValue = clear ? "" : this.developmentOperationInputText.getText().toString();
            this.developmentOperationInputText.setText((CharSequence)String.format("%s %s %s", oldValue, value, operator));
        }
    }

    private void removeLastNumber() {
        String value = this.inputNumberText.getText().toString();
        if (value.length() != 0) {
            this.inputNumberText.setText(value.substring(0, value.length() - 1));
        }
    }

    private void clear() {
        this.equalBtn.setVisibility(8);
        this.submitBtn.setVisibility(0);
        this.firstValue = null;
        this.secondsValue = null;
        this.operatorExecute = "none";
        this.prevOperatorExecute = "none";
        this.developmentOperationInputText.setText((CharSequence)"");
        this.inputNumberText.setText("");
    }

    private void setOnClickListenerBtn(List<Button> buttons, View.OnClickListener onClickListener) {
        for (Button button : buttons) {
            button.setOnClickListener(onClickListener);
        }
    }

    private void returnResultOperation() {
        String result = this.inputNumberText.getText().toString();
        Intent resultIntent = new Intent();
        if (result.equals(POINT)) {
            result = "";
        }
        resultIntent.putExtra(RESULT, result);
        this.setResult(2, resultIntent);
        this.finish();
    }

    private void replaceOperator(String operator) {
        String operationValue = this.developmentOperationInputText.getText().toString();
        if (TextUtils.isEmpty((CharSequence)operationValue)) {
            return;
        }
        String oldOperator = operationValue.substring(operationValue.length() - 1, operationValue.length());
        if (oldOperator.equals(operator)) {
            return;
        }
        String operationNewValue = operationValue.substring(0, operationValue.length() - 2);
        this.concatDevelopingOperation(operator, operationNewValue, true);
    }

    private String formatValue(double value) {
        String valueStr = this.decimalFormat.format(value);
        String integerValue = valueStr.substring(0, valueStr.indexOf(POINT));
        String decimalValue = valueStr.substring(valueStr.indexOf(POINT) + 1, valueStr.length());
        if (decimalValue.equals(ZERO_ZERO) || decimalValue.equals(ZERO)) {
            return integerValue;
        }
        return valueStr;
    }
}

