/*
 * Decompiled with CFR 0.152.
 */
package com.gp89developers.calculatorinputview.widget;

import android.content.Context;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class NumericEditText
extends AppCompatEditText {
    private final char GROUPING_SEPARATOR = (char)44;
    private final char DECIMAL_SEPARATOR = (char)46;
    private final String LEADING_ZERO_FILTER_REGEX = "^0+(?!$)";
    private String mDefaultText = null;
    private String mPreviousText = "";
    private String mNumberFilterRegex = "[^\\d\\.]";
    private char mDecimalSeparator = (char)46;
    private boolean hasCustomDecimalSeparator = false;
    private List<NumericValueWatcher> mNumericListeners = new ArrayList<NumericValueWatcher>();
    private final TextWatcher mTextWatcher = new TextWatcher(){
        private boolean validateLock = false;

        public void afterTextChanged(Editable s) {
            if (this.validateLock) {
                return;
            }
            if (StringUtils.countMatches((CharSequence)s.toString(), (CharSequence)String.valueOf(NumericEditText.this.mDecimalSeparator)) > 1) {
                this.validateLock = true;
                NumericEditText.this.setText(NumericEditText.this.mPreviousText);
                NumericEditText.this.setSelection(NumericEditText.this.mPreviousText.length());
                this.validateLock = false;
                return;
            }
            if (s.length() == 0) {
                NumericEditText.this.handleNumericValueCleared();
                return;
            }
            NumericEditText.this.setTextInternal(NumericEditText.this.format(s.toString()));
            NumericEditText.this.setSelection(NumericEditText.this.getText().length());
            NumericEditText.this.handleNumericValueChanged();
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }
    };

    public NumericEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.addTextChangedListener(this.mTextWatcher);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NumericEditText.this.setSelection(NumericEditText.this.getText().length());
            }
        });
    }

    private void handleNumericValueCleared() {
        this.mPreviousText = "";
        for (NumericValueWatcher listener : this.mNumericListeners) {
            listener.onCleared();
        }
    }

    private void handleNumericValueChanged() {
        this.mPreviousText = this.getText().toString();
        for (NumericValueWatcher listener : this.mNumericListeners) {
            listener.onChanged(this.getNumericValue());
        }
    }

    public void addNumericValueChangedListener(NumericValueWatcher watcher) {
        this.mNumericListeners.add(watcher);
    }

    public void removeAllNumericValueChangedListeners() {
        while (!this.mNumericListeners.isEmpty()) {
            this.mNumericListeners.remove(0);
        }
    }

    public void setDefaultNumericValue(double defaultNumericValue, String defaultNumericFormat) {
        this.mDefaultText = String.format(defaultNumericFormat, defaultNumericValue);
        if (this.hasCustomDecimalSeparator) {
            this.mDefaultText = StringUtils.replace((String)this.mDefaultText, (String)String.valueOf('.'), (String)String.valueOf(this.mDecimalSeparator));
        }
        this.setTextInternal(this.mDefaultText);
    }

    public void setCustomDecimalSeparator(char customDecimalSeparator) {
        this.mDecimalSeparator = customDecimalSeparator;
        this.hasCustomDecimalSeparator = true;
        this.mNumberFilterRegex = "[^\\d\\" + this.mDecimalSeparator + "]";
    }

    public void clear() {
        this.setTextInternal(this.mDefaultText != null ? this.mDefaultText : "");
        if (this.mDefaultText != null) {
            this.handleNumericValueChanged();
        }
    }

    public double getNumericValue() {
        String original = this.getText().toString().replaceAll(this.mNumberFilterRegex, "");
        if (this.hasCustomDecimalSeparator) {
            original = StringUtils.replace((String)original, (String)String.valueOf(this.mDecimalSeparator), (String)String.valueOf('.'));
        }
        try {
            return NumberFormat.getInstance().parse(original).doubleValue();
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    private String format(String original) {
        String[] parts = original.split("\\" + this.mDecimalSeparator, -1);
        String number = parts[0].replaceAll(this.mNumberFilterRegex, "").replaceFirst("^0+(?!$)", "");
        if (!this.hasCustomDecimalSeparator) {
            number = StringUtils.reverse((String)StringUtils.reverse((String)number).replaceAll("(.{3})", "$1,"));
            number = StringUtils.removeStart((String)number, (String)String.valueOf(','));
        }
        if (parts.length > 1) {
            number = parts[1].length() > 2 ? number + this.mDecimalSeparator + parts[1].substring(parts[1].length() - 2, parts[1].length()) : number + this.mDecimalSeparator + parts[1];
        }
        return number;
    }

    private void setTextInternal(String text) {
        this.removeTextChangedListener(this.mTextWatcher);
        this.setText(text);
        this.addTextChangedListener(this.mTextWatcher);
    }

    static interface NumericValueWatcher {
        public void onChanged(double var1);

        public void onCleared();
    }
}

