/*
 * Decompiled with CFR 0.152.
 */
package asteroid.internal;

import asteroid.A;
import asteroid.AbstractLocalTransformation;
import asteroid.Expressions;
import asteroid.Phase;
import asteroid.Statements;
import asteroid.Utils;
import asteroid.internal.TransformationUtils;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class PhaseTransformation
extends AbstractLocalTransformation<Phase, ClassNode> {
    private static final String METHOD_DOVISIT = "doVisit";

    public PhaseTransformation() {
        super(Phase.class);
    }

    @Override
    public void doVisit(AnnotationNode annotationNode, ClassNode annotatedNode) {
        if (!Utils.NODE.isOrExtends(annotatedNode, AbstractLocalTransformation.class).booleanValue()) {
            return;
        }
        CompilePhase phase = this.extractCompilePhaseFrom(annotationNode);
        TransformationUtils.addASTAnnotationsFromTo(annotatedNode, phase);
        this.addClassConstructor(annotatedNode);
        Utils.NODE.addCheckTo(Utils.NODE.findMethodByName(annotatedNode, METHOD_DOVISIT));
        Utils.NODE.removeAnnotation((AnnotatedNode)annotatedNode, annotationNode);
    }

    private void addClassConstructor(ClassNode annotatedNode) {
        List<GenericsType> generics = Arrays.asList(annotatedNode.getSuperClass().getGenericsTypes());
        ClassNode annotationType = ((GenericsType)DefaultGroovyMethods.first(generics)).getType();
        Expression[] expressionArray = new Expression[1];
        expressionArray[0] = Expressions.classX(annotationType);
        Statement callSuper = Statements.ctorSuperS(expressionArray);
        ConstructorNode constructorNode = A.NODES.constructor(1).code(callSuper).build();
        annotatedNode.addConstructor(constructorNode);
    }

    private CompilePhase extractCompilePhaseFrom(AnnotationNode annotationNode) {
        String phaseAsString = Utils.NODE.get(annotationNode, String.class);
        CompilePhase compilePhase = CompilePhase.valueOf((String)phaseAsString);
        return compilePhase;
    }
}

