/*
 * Decompiled with CFR 0.152.
 */
package asteroid.internal;

import asteroid.A;
import asteroid.Expressions;
import groovy.transform.InheritConstructors;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.transform.GroovyASTTransformation;

public final class TransformationUtils {
    private TransformationUtils() {
    }

    public static void addASTAnnotationsFromTo(ClassNode annotated, CompilePhase compilePhase) {
        AnnotationNode groovyAnn = TransformationUtils.getGroovyAnnotation(compilePhase);
        AnnotationNode inheritConsAnn = TransformationUtils.getInheritConstructorsAnnotation();
        annotated.addAnnotation(inheritConsAnn);
        annotated.addAnnotation(groovyAnn);
    }

    public static AnnotationNode getGroovyAnnotation(CompilePhase compilePhase) {
        PropertyExpression valueExpr = TransformationUtils.getCompilePhaseAsPropertyExpression(compilePhase);
        return A.NODES.annotation(GroovyASTTransformation.class).member("phase", (Expression)valueExpr).build();
    }

    public static PropertyExpression getCompilePhaseAsPropertyExpression(CompilePhase compilePhase) {
        return Expressions.propX((Expression)Expressions.classX(CompilePhase.class), (Expression)Expressions.constX(compilePhase));
    }

    public static AnnotationNode getInheritConstructorsAnnotation() {
        return A.NODES.annotation(InheritConstructors.class).build();
    }
}

