/*
 * Decompiled with CFR 0.152.
 */
package asteroid.internal;

import asteroid.A;
import asteroid.Expressions;
import asteroid.Local;
import asteroid.Utils;
import groovy.lang.Closure;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformationClass;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class LocalTransformation
extends AbstractASTTransformation {
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.sourceUnit = source;
        if (!this.check(nodes)) {
            return;
        }
        AnnotationNode annotationNode = Utils.NODE.getFirstNodeAs(nodes, AnnotationNode.class);
        ClassNode annotatedNode = Utils.NODE.getLastNodeAs(nodes, ClassNode.class);
        this.addAnnotationsFromTo(annotationNode, annotatedNode);
    }

    private void addAnnotationsFromTo(AnnotationNode annotationNode, ClassNode annotatedNode) {
        String qualifiedName = Utils.NODE.get(annotationNode, String.class);
        String target = Utils.NODE.get(annotationNode, "applyTo", String.class);
        annotatedNode.addAnnotation(this.getTargetAnnotation(target));
        annotatedNode.addAnnotation(this.getRetentionAnnotation());
        annotatedNode.addAnnotation(this.getGroovyAnnotationWith(qualifiedName));
    }

    private AnnotationNode getTargetAnnotation(String resolvedTarget) {
        List<ElementType> types = this.resolveAnnotationTarget(resolvedTarget);
        ListExpression listExpr = this.resolveTargetFromElementType(types);
        return A.NODES.annotation(Target.class).member("value", (Expression)listExpr).build();
    }

    private ListExpression resolveTargetFromElementType(List<ElementType> types) {
        List expressions = DefaultGroovyMethods.collect(types, (Closure)new Closure<PropertyExpression>(null){

            PropertyExpression doCall(ElementType type) {
                return Expressions.propX((Expression)Expressions.classX(ElementType.class), (Expression)Expressions.constX(type.toString()));
            }
        });
        return Expressions.listX((Expression[])expressions.toArray(new PropertyExpression[expressions.size()]));
    }

    private List<ElementType> resolveAnnotationTarget(String target) {
        if (target == null) {
            return Arrays.asList(ElementType.TYPE);
        }
        if ("ANNOTATED".equals(target)) {
            return Arrays.asList(ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.FIELD, ElementType.LOCAL_VARIABLE, ElementType.METHOD, ElementType.PACKAGE, ElementType.PARAMETER, ElementType.TYPE);
        }
        return Arrays.asList(ElementType.valueOf(target));
    }

    private AnnotationNode getRetentionAnnotation() {
        ClassExpression classExpr = Expressions.classX(RetentionPolicy.class);
        ConstantExpression constantExpr = Expressions.constX(RetentionPolicy.SOURCE.toString());
        PropertyExpression propertyExpr = Expressions.propX((Expression)classExpr, (Expression)constantExpr);
        return A.NODES.annotation(Retention.class).member("value", (Expression)propertyExpr).build();
    }

    private AnnotationNode getGroovyAnnotationWith(String qualifiedName) {
        ConstantExpression constant = Expressions.constX(qualifiedName);
        return A.NODES.annotation(GroovyASTTransformationClass.class).member("value", (Expression)constant).build();
    }

    private boolean check(ASTNode ... nodes) {
        return !this.thereIsNoNodes(nodes) && !this.thereAreOtherThanTwo(nodes) && !this.firstNodeIsNotAnAnnotation(nodes) && !this.firstNodeIsNotAnAnnotationOfType(nodes, Local.class) && !this.lastNodeIsNotAnAnnotatedNode(nodes);
    }

    private boolean thereIsNoNodes(ASTNode ... nodes) {
        return nodes == null;
    }

    private boolean thereAreOtherThanTwo(ASTNode ... nodes) {
        return nodes.length != 2;
    }

    private boolean firstNodeIsNotAnAnnotation(ASTNode ... nodes) {
        return !(DefaultGroovyMethods.first((Object[])nodes) instanceof AnnotationNode);
    }

    private boolean lastNodeIsNotAnAnnotatedNode(ASTNode ... nodes) {
        return !(DefaultGroovyMethods.last((Object[])nodes) instanceof AnnotatedNode);
    }

    private boolean firstNodeIsNotAnAnnotationOfType(ASTNode[] nodes, Class annotationType) {
        AnnotationNode annotation = Utils.NODE.getFirstNodeAs(nodes, AnnotationNode.class);
        ClassNode annotationClass = A.NODES.clazz(annotationType).build();
        return !annotation.getClassNode().isDerivedFrom(annotationClass);
    }
}

