/*
 * Decompiled with CFR 0.152.
 */
package asteroid.internal;

import asteroid.A;
import asteroid.AbstractGlobalTransformation;
import asteroid.Criterias;
import asteroid.Utils;
import asteroid.internal.TransformationUtils;
import asteroid.transformer.AbstractClassNodeTransformer;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;

public class TranslateToGlobalTransform
extends AbstractClassNodeTransformer {
    private static final String BLANK = "";
    private static final String TX_NAME = "Phase";
    private static final String PHASE_PFIX = "Phase.GLOBAL.";
    private static final String PHASE_PFIX_SHORT = "GLOBAL.";
    private static final String PHASE_GROOVY = "CompilePhase.";
    private static final String PHASE_WRONG = "GlobalAnnotation compilation phase is wrong!!";
    private static final String PHASE_MISSING = "GlobalAnnotation compilation phase is missing!!";

    public TranslateToGlobalTransform(SourceUnit sourceUnit) {
        super(sourceUnit, Criterias.byAnnotationSimpleName(TX_NAME));
    }

    @Override
    public void transformClass(ClassNode annotated) {
        ClassNode superClass = annotated.getSuperClass();
        if (superClass == null) {
            return;
        }
        ClassNode reference = A.NODES.clazz(AbstractGlobalTransformation.class).build();
        Boolean isGlobal = Utils.NODE.isOrExtendsUnsafe(annotated, reference);
        if (!isGlobal.booleanValue()) {
            return;
        }
        AnnotationNode annotation = Utils.NODE.getAnnotationFrom(annotated, TX_NAME);
        CompilePhase phase = this.extractCompilePhaseFromSafely(annotation);
        TransformationUtils.addASTAnnotationsFromTo(annotated, phase);
        Utils.NODE.removeAnnotation((AnnotatedNode)annotated, annotation);
    }

    private CompilePhase extractCompilePhaseFromSafely(AnnotationNode annotationNode) {
        try {
            return this.extractCompilePhaseFrom(annotationNode);
        }
        catch (IllegalArgumentException iaex) {
            throw new GroovyBugError(PHASE_WRONG, (Exception)iaex);
        }
        catch (Exception ex) {
            throw new GroovyBugError(PHASE_MISSING, ex);
        }
    }

    private CompilePhase extractCompilePhaseFrom(AnnotationNode annotationNode) {
        String value = Utils.NODE.getStringValue(annotationNode);
        String phaseAsString = value.replace(PHASE_GROOVY, BLANK).replace(PHASE_PFIX, BLANK).replace(PHASE_PFIX_SHORT, BLANK);
        CompilePhase compilePhase = CompilePhase.valueOf((String)phaseAsString);
        return compilePhase;
    }
}

