/*
 * Decompiled with CFR 0.152.
 */
package asteroid.transformer;

import asteroid.transformer.AbstractTransformer;
import groovy.lang.Closure;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.control.SourceUnit;

public abstract class AbstractExpressionTransformer<T extends Expression>
extends AbstractTransformer {
    private final Closure<Boolean> criteria;
    private final Class<T> clazz;

    public AbstractExpressionTransformer(Class<T> clazz, SourceUnit sourceUnit, Closure<Boolean> criteria) {
        super(sourceUnit);
        this.clazz = clazz;
        this.criteria = criteria;
    }

    public AbstractExpressionTransformer(Class<T> clazz, SourceUnit sourceUnit) {
        super(sourceUnit);
        this.clazz = clazz;
        this.criteria = AbstractExpressionTransformer.everything();
    }

    public Expression transform(Expression expression) {
        if (expression == null) {
            return null;
        }
        boolean matches = AbstractExpressionTransformer.isOfTypeAndMatchesCriteria(expression, this.clazz, this.criteria);
        if (matches) {
            return this.transformExpression(expression);
        }
        return expression.transformExpression((ExpressionTransformer)this);
    }

    private static boolean isOfTypeAndMatchesCriteria(Expression expression, Class clazz, Closure<Boolean> predicate) {
        return AbstractExpressionTransformer.isOfType(expression, clazz) && (Boolean)predicate.call((Object)expression) != false;
    }

    private static boolean isOfType(Expression expression, Class clazz) {
        return clazz != null && clazz.isInstance(expression);
    }

    public abstract Expression transformExpression(T var1);

    @Deprecated
    public static Closure<Boolean> everything() {
        return new Closure<Boolean>(null){

            public Boolean doCall(Expression expression) {
                return true;
            }
        };
    }
}

