/*
 * Decompiled with CFR 0.152.
 */
package asteroid.utils;

import groovy.lang.Closure;
import java.util.List;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public final class ExpressionUtils {
    public boolean hasArguments(MethodCallExpression methodCallExpr) {
        return this.getArgumentList(methodCallExpr).getExpressions().isEmpty();
    }

    public ArgumentListExpression getArgumentList(MethodCallExpression methodCallExpr) {
        return (ArgumentListExpression)methodCallExpr.getArguments();
    }

    public <U extends Expression> U getFirstArgumentAs(MethodCallExpression methodCallExpr, Class<U> asType) {
        return (U)((Expression)asType.cast(DefaultGroovyMethods.first((List)this.getArgumentList(methodCallExpr).getExpressions())));
    }

    public <U extends Expression> U getFirstArgumentAs(ArgumentListExpression args, Class<U> asType) {
        return (U)((Expression)asType.cast(DefaultGroovyMethods.first((List)args.getExpressions())));
    }

    public <U extends Expression> U getArgumentByIndexAs(MethodCallExpression methodCallExpr, Integer index, Class<U> asType) {
        List expressionList = this.getArgumentList(methodCallExpr).getExpressions();
        if (expressionList.isEmpty() || expressionList.size() < index) {
            return null;
        }
        return (U)((Expression)asType.cast(expressionList.get(index)));
    }

    public <U extends Expression> U getArgumentByIndexAs(ArgumentListExpression args, Integer index, Class<U> asType) {
        List expressionList = args.getExpressions();
        if (expressionList.isEmpty() || expressionList.size() < index) {
            return null;
        }
        return (U)((Expression)asType.cast(expressionList.get(index)));
    }

    public <U extends Expression> U getLastArgumentAs(MethodCallExpression methodCallExpr, Class<U> asType) {
        return (U)((Expression)asType.cast(DefaultGroovyMethods.last((List)this.getArgumentList(methodCallExpr).getExpressions())));
    }

    public <U extends Expression> U getLastArgumentAs(ArgumentListExpression args, Class<U> asType) {
        return (U)((Expression)asType.cast(DefaultGroovyMethods.last((List)args.getExpressions())));
    }

    public boolean isMethodCallExpr(Expression expr) {
        return expr instanceof MethodCallExpression;
    }

    public boolean isListExpr(Expression expr) {
        return expr instanceof ListExpression;
    }

    public boolean isBinaryExpr(Expression expr) {
        return expr instanceof BinaryExpression;
    }

    public boolean isBinaryExpr(Expression expr, int operator) {
        return this.isBinaryExpr(expr) && this.asBinaryExpr(expr).getOperation().getType() == operator;
    }

    public <T> T asBinaryExpr(Expression expr, T defaultValue, Closure<T> func) {
        return (T)(this.isBinaryExpr(expr) ? func.call((Object)this.asBinaryExpr(expr)) : defaultValue);
    }

    public BinaryExpression asBinaryExpr(Expression expr) {
        return (BinaryExpression)expr;
    }

    public <T> T leftExprAs(BinaryExpression binaryExpr, Class<T> type) {
        return type.cast(binaryExpr.getLeftExpression());
    }

    public <T> T rightExprAs(BinaryExpression binaryExpr, Class<T> type) {
        return type.cast(binaryExpr.getRightExpression());
    }

    public String getText(Expression expression) {
        if (expression == null) {
            return "";
        }
        if (expression instanceof ConstantExpression) {
            return ((ConstantExpression)expression).getText();
        }
        return expression.toString();
    }
}

