/*
 * Decompiled with CFR 0.152.
 */
package asteroid.utils;

import asteroid.Expressions;
import asteroid.Statements;
import asteroid.Utils;
import asteroid.nodes.AnnotationNodeBuilder;
import asteroid.utils.StatementUtils;
import groovy.lang.Closure;
import groovy.transform.Generated;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;

public class NodeUtils {
    public static final String ANNOTATION_VALUE = "value";
    private static final AnnotationNode GENERATED = AnnotationNodeBuilder.annotation(Generated.class).build();

    public void addCheckTo(MethodNode methodNode) {
        BlockStatement blockStmt = Utils.NODE.getCodeBlock(methodNode);
        List<StatementUtils.Group> groups = Utils.STMT.groupStatementsByLabel(blockStmt);
        List<Statement> statements = Utils.STMT.applyToStatementsByLabelFlatten(groups, this.getMappings());
        if (!groups.isEmpty()) {
            methodNode.setCode((Statement)Statements.blockS(statements));
        }
    }

    private Map<String, Closure<Statement>> getMappings() {
        HashMap<String, Closure<Statement>> mappings = new HashMap<String, Closure<Statement>>();
        mappings.put("check", this.buildAssertionStmt());
        return mappings;
    }

    private Closure<Statement> buildAssertionStmt() {
        return new Closure<Statement>(null){

            public Statement doCall(StatementUtils.Group group, ExpressionStatement stmt) {
                return NodeUtils.this.createAssertStatement(group, stmt);
            }
        };
    }

    private Statement createAssertStatement(StatementUtils.Group group, ExpressionStatement stmt) {
        Expression expression = group.label.expression;
        return Statements.assertS(Expressions.boolX(stmt.getExpression()), Utils.EXPR.getText(expression));
    }

    public <T> T getFirstNodeAs(ASTNode[] nodes, Class<T> clazz) {
        return (T)DefaultGroovyMethods.first((Object[])nodes);
    }

    public <T> T getLastNodeAs(ASTNode[] nodes, Class<T> clazz) {
        return (T)DefaultGroovyMethods.last((Object[])nodes);
    }

    public String getStringValue(AnnotationNode annotationNode) {
        Expression expr = annotationNode.getMember(ANNOTATION_VALUE);
        if (expr != null) {
            return expr.getText();
        }
        return null;
    }

    public <T> T get(AnnotationNode annotationNode, Class<T> clazz) {
        Object value = this.resolveValueFrom(annotationNode.getMember(ANNOTATION_VALUE));
        return clazz.cast(value);
    }

    public <T> T get(AnnotationNode annotationNode, String name, Class<T> clazz) {
        Object value = this.resolveValueFrom(annotationNode.getMember(name));
        return clazz.cast(value);
    }

    private Object resolveValueFrom(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof ClassExpression) {
            return ((ClassExpression)ClassExpression.class.cast(expression)).getText();
        }
        if (expression instanceof ConstantExpression) {
            return ((ConstantExpression)ConstantExpression.class.cast(expression)).getValue();
        }
        if (expression instanceof PropertyExpression) {
            return ((PropertyExpression)PropertyExpression.class.cast(expression)).getPropertyAsString();
        }
        return expression.toString();
    }

    public void addGeneratedField(ClassNode classNode, FieldNode fieldNode) {
        fieldNode.addAnnotation(GENERATED);
        classNode.addField(fieldNode);
    }

    public void addGeneratedFieldIfNotPresent(ClassNode classNode, FieldNode fieldNode) {
        if (!this.hasField(classNode, fieldNode.getName()).booleanValue()) {
            this.addGeneratedField(classNode, fieldNode);
        }
    }

    public void addProperty(ClassNode classNode, PropertyNode propertyNode) {
        classNode.addProperty(propertyNode);
    }

    public void addPropertyIfNotPresent(ClassNode classNode, PropertyNode propertyNode) {
        if (!classNode.hasProperty(propertyNode.getName())) {
            classNode.addProperty(propertyNode);
        }
    }

    public void addMethod(ClassNode classNode, MethodNode methodNode) {
        classNode.addMethod(methodNode);
    }

    public void addGeneratedMethod(ClassNode classNode, MethodNode methodNode) {
        methodNode.addAnnotation(GENERATED);
        this.addMethod(classNode, methodNode);
    }

    public void addMethodIfNotPresent(ClassNode classNode, MethodNode methodNode) {
        if (!classNode.hasMethod(methodNode.getName(), methodNode.getParameters())) {
            this.addMethod(classNode, methodNode);
        }
    }

    public void addGeneratedMethodIfNotPresent(ClassNode classNode, MethodNode methodNode) {
        if (!classNode.hasMethod(methodNode.getName(), methodNode.getParameters())) {
            this.addGeneratedMethod(classNode, methodNode);
        }
    }

    public void addInterfaces(ClassNode classNode, Class ... interfaces) {
        for (Class clazz : interfaces) {
            ClassNode nextInterface = ClassHelper.make((Class)clazz, (boolean)false);
            classNode.addInterface(nextInterface);
        }
    }

    public void addInterfaces(ClassNode classNode, ClassNode ... interfaces) {
        for (ClassNode nextInterface : interfaces) {
            classNode.addInterface(nextInterface);
        }
    }

    public List<FieldNode> getInstancePropertyFields(ClassNode classNode) {
        return GeneralUtils.getInstancePropertyFields((ClassNode)classNode);
    }

    public AnnotationNode getAnnotationFrom(ClassNode classNode, ClassNode annotationType) {
        return (AnnotationNode)DefaultGroovyMethods.find((Collection)classNode.getAnnotations(annotationType));
    }

    public AnnotationNode getAnnotationFrom(ClassNode classNode, String simpleName) {
        return (AnnotationNode)DefaultGroovyMethods.find((Collection)classNode.getAnnotations(), this.bySimpleName(simpleName));
    }

    public void removeAnnotation(AnnotatedNode annotated, AnnotationNode annotation) {
        annotated.getAnnotations().remove(annotation);
    }

    private Closure<Boolean> bySimpleName(final String annotationName) {
        return new Closure(null){

            public boolean doCall(AnnotationNode node) {
                return node.getClassNode().getNameWithoutPackage().equals(annotationName);
            }
        };
    }

    public Boolean hasField(ClassNode node, String fieldName) {
        List nodeFields = node.getFields();
        for (FieldNode fieldNode : nodeFields) {
            if (!fieldNode.getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    public FieldNode findFieldByName(ClassNode node, String name) {
        List nodeFields = node.getFields();
        for (FieldNode fieldNode : nodeFields) {
            if (!fieldNode.getName().equals(name)) continue;
            return fieldNode;
        }
        return null;
    }

    public Boolean hasFieldOfType(ClassNode node, final String qualifiedName) {
        List nodeFields = node.getFields();
        Closure<Boolean> predicate = new Closure<Boolean>(null){

            public Boolean doCall(FieldNode fieldNode) {
                return NodeUtils.this.isOrExtends(fieldNode.getType(), qualifiedName);
            }
        };
        return DefaultGroovyMethods.any((Iterable)nodeFields, (Closure)predicate);
    }

    public Boolean isOrImplements(Class child, Class parent) {
        return this.isOrImplements(ClassHelper.make((Class)child, (boolean)false), parent);
    }

    public Boolean isOrImplements(ClassNode child, Class parent) {
        return GeneralUtils.isOrImplements((ClassNode)child, (ClassNode)ClassHelper.make((Class)parent, (boolean)false));
    }

    public Boolean isOrImplements(ClassNode child, String parent) {
        return GeneralUtils.isOrImplements((ClassNode)child, (ClassNode)ClassHelper.make((String)parent));
    }

    public Boolean isOrExtends(ClassNode child, Class parent) {
        ClassNode extendedType = ClassHelper.make((Class)parent, (boolean)false);
        return this.isOrExtends(child, extendedType);
    }

    public Boolean isOrExtends(ClassNode child, ClassNode parent) {
        return child.equals((Object)parent) || child.isDerivedFrom(parent);
    }

    public Boolean isOrExtends(ClassNode child, String parent) {
        return child.equals((Object)parent) || child.isDerivedFrom(ClassHelper.make((String)parent));
    }

    public Boolean isOrExtendsUnsafe(ClassNode child, ClassNode parent) {
        return child.equals((Object)parent) || child.isDerivedFrom(parent) || child.getSuperClass().getNameWithoutPackage().equals(parent.getNameWithoutPackage());
    }

    public MethodNode findMethodByName(ClassNode classNode, String methodName) {
        return (MethodNode)DefaultGroovyMethods.first(this.findAllMethodByName(classNode, methodName));
    }

    public List<MethodNode> findAllMethodByName(ClassNode classNode, String methodName) {
        return classNode.getMethods(methodName);
    }

    public void addImport(ClassNode classNode, Class clazz) {
        classNode.getModule().addImport(clazz.getSimpleName(), ClassHelper.make((Class)clazz, (boolean)false));
    }

    public void addImport(ClassNode classNode, String clazz) {
        classNode.getModule().addImport(this.getClassNameFromString(clazz), ClassHelper.make((String)clazz));
    }

    private String getClassNameFromString(String clazz) {
        if (clazz == null || clazz.isEmpty()) {
            return clazz;
        }
        int clazzPackage = clazz.lastIndexOf(46);
        String name = StringGroovyMethods.take((String)clazz, (int)clazzPackage);
        return name.toString();
    }

    public void addImport(ClassNode classNode, Class clazz, String alias) {
        classNode.getModule().addImport(alias, ClassHelper.make((Class)clazz, (boolean)false));
    }

    public void addImport(ClassNode classNode, String clazz, String alias) {
        classNode.getModule().addImport(alias, ClassHelper.make((String)clazz));
    }

    public BlockStatement getCodeBlock(MethodNode methodNode) {
        return (BlockStatement)methodNode.getCode();
    }

    public void addBeforeCodeBlock(MethodNode methodNode, Statement statement) {
        methodNode.setCode((Statement)Statements.blockS(new Statement[]{statement, this.getCodeBlock(methodNode)}));
    }

    public void addAfterCodeBlock(MethodNode methodNode, Statement statement) {
        methodNode.setCode((Statement)Statements.blockS(new Statement[]{this.getCodeBlock(methodNode), statement}));
    }

    public void addAroundCodeBlock(MethodNode methodNode, Statement before, Statement after) {
        methodNode.setCode((Statement)Statements.blockS(new Statement[]{before, this.getCodeBlock(methodNode), after}));
    }
}

