/*
 * Decompiled with CFR 0.152.
 */
package asteroid.utils;

import asteroid.Expressions;
import asteroid.utils.InternalUtils;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public final class StatementUtils {
    public List<Group> groupStatementsByLabel(BlockStatement blockStmt) {
        return (List)DefaultGroovyMethods.inject((Collection)blockStmt.getStatements(), new ArrayList(), this.groupByLabel());
    }

    private Closure<List<Group>> groupByLabel() {
        return new Closure<List<Group>>(null){

            public List<Group> doCall(List<Group> acc, Statement stmt) {
                Group currentGroup;
                Label label = StatementUtils.this.extractLabelFrom(stmt);
                Group group = currentGroup = acc.isEmpty() ? null : (Group)DefaultGroovyMethods.last(acc);
                if (label == null && currentGroup != null) {
                    currentGroup.statements.add(stmt);
                } else if (label != null) {
                    acc.add(new Group(label, new ArrayList<Statement>()));
                }
                return acc;
            }
        };
    }

    public Label extractLabelFrom(Statement stmt) {
        boolean isThereAnyLabel;
        boolean isExprStmt = stmt instanceof ExpressionStatement;
        if (!isExprStmt) {
            return null;
        }
        ExpressionStatement exprStmt = (ExpressionStatement)stmt;
        String labelName = exprStmt.getStatementLabel();
        boolean bl = isThereAnyLabel = labelName != null;
        if (!isThereAnyLabel) {
            return null;
        }
        Expression labelExpr = exprStmt.getExpression();
        return new Label(labelName, labelExpr);
    }

    public List<Statement> applyToStatementsByLabelFlatten(List<Group> source, Map<String, Closure<Statement>> mappings) {
        List<Group> stmtGroupList = this.applyToStatementsByLabel(source, mappings);
        ArrayList<Statement> flattenStmtList = new ArrayList<Statement>();
        for (Group group : stmtGroupList) {
            flattenStmtList.addAll(group.statements);
        }
        return flattenStmtList;
    }

    public List<Group> applyToStatementsByLabel(List<Group> source, Map<String, Closure<Statement>> mappings) {
        return (List)DefaultGroovyMethods.inject(source, new ArrayList(), this.transformByLabelName(mappings));
    }

    private Closure<List<Group>> transformByLabelName(final Map<String, Closure<Statement>> mappings) {
        return new Closure<List<Group>>(null){

            public List<Group> doCall(List<Group> acc, Group group) {
                Closure trx = (Closure)mappings.get(group.label.name);
                List<Statement> source = group.statements;
                List<Statement> destin = trx == null ? InternalUtils.collect(source) : InternalUtils.collect(source, trx.curry((Object)group));
                acc.add(group.copyWithStatements(destin));
                return acc;
            }
        };
    }

    public static class Label {
        public final String name;
        public final Expression expression;

        Label(String name, Expression expression) {
            this.name = name;
            this.expression = expression;
        }

        public ConstantExpression nameAsExpression() {
            return this.name != null ? Expressions.constX(this.name) : null;
        }
    }

    public static class Group {
        public final Label label;
        public final List<Statement> statements;

        Group(Label label, List<Statement> statements) {
            this.label = label;
            this.statements = statements;
        }

        public Group copyWithStatements(List<Statement> newStatements) {
            return new Group(new Label(this.label.name, this.label.expression), newStatements);
        }
    }
}

