/*
 * Decompiled with CFR 0.152.
 */
package com.github.gsdenys;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class CmisInMemoryRunner
extends BlockJUnit4ClassRunner {
    private static boolean initialized = false;
    private final String CMIS_LIB_NAME_WAR = "chemistry-opencmis-server-inmemory";
    private final String JETTY_RELATIVE_PATH = "eclipse/jetty/jetty-xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmisInMemoryRunner(Class<?> klass) throws InitializationError {
        super(klass);
        Class<CmisInMemoryRunner> clazz = CmisInMemoryRunner.class;
        synchronized (CmisInMemoryRunner.class) {
            if (!initialized) {
                String filePath = this.getWarFromJavaClassPath();
                try {
                    initialized = this.startJettyServer(filePath, 8080);
                }
                catch (Exception e) {
                    throw new InitializationError((Throwable)e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private boolean startJettyServer(String cmisWar, Integer port) throws Exception {
        Server server = new Server(port.intValue());
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/cmis/");
        webapp.setWar(cmisWar);
        server.setHandler((Handler)webapp);
        server.start();
        return true;
    }

    private StringBuilder buildLibURL(String base) {
        String cmisRelativePath = "apache/chemistry/opencmis/";
        String libVersion = "1.0.0";
        StringBuilder builder = new StringBuilder();
        builder.append(base);
        builder.append("apache/chemistry/opencmis/");
        builder.append("chemistry-opencmis-server-inmemory");
        builder.append("/");
        builder.append("1.0.0");
        builder.append("/");
        builder.append("chemistry-opencmis-server-inmemory");
        builder.append("-");
        builder.append("1.0.0");
        builder.append(".war");
        return builder;
    }

    private String getWarFromRelativePath() {
        String regex = "(.*:)([a-zA-Z0-9/.-]+)(eclipse/jetty/jetty-xml)(.*)";
        Pattern pattern = Pattern.compile("(.*:)([a-zA-Z0-9/.-]+)(eclipse/jetty/jetty-xml)(.*)");
        Matcher matcher = pattern.matcher(System.getProperty("java.class.path"));
        if (!matcher.find()) {
            return null;
        }
        return this.buildLibURL(matcher.group(2)).toString();
    }

    private String getWarFromJavaClassPath() {
        String regex = "(.*:)([a-zA-Z0-9/.-]+chemistry-opencmis-server-inmemory[a-zA-Z0-9/.-]*.war)(.*)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(System.getProperty("java.class.path"));
        return matcher.find() ? matcher.group(2) : this.getWarFromRelativePath();
    }
}

