/*
 * Decompiled with CFR 0.152.
 */
package com.github.guillaumederval.javagrading;

import com.github.guillaumederval.javagrading.TestStatus;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.StringJoiner;

class Format {
    private static DecimalFormat df = Format.initDF();

    Format() {
    }

    private static DecimalFormat initDF() {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.getGroupingSeparator();
        return new DecimalFormat("0.##", otherSymbols);
    }

    static String format(double d) {
        return df.format(d);
    }

    static String replace(String orig, String toFind, String replaceBy) {
        String[] lines = orig.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            int foundIdx = lines[i].indexOf(toFind);
            if (foundIdx == -1) continue;
            lines[i] = Format.prefix(replaceBy, lines[i].substring(0, foundIdx));
        }
        StringJoiner sj = new StringJoiner("\n");
        for (String s : lines) {
            sj.add(s);
        }
        return sj.toString();
    }

    static String prefix(String orig, String prefix) {
        String[] lines = orig.split("\n");
        StringJoiner sj = new StringJoiner("\n");
        for (String s : lines) {
            sj.add(prefix + s);
        }
        return sj.toString();
    }

    static String csvEscape(String orig) {
        orig = orig.replaceAll("\"", "\"\"");
        return "\"" + orig + "\"";
    }

    static String statusToIcon(TestStatus status) {
        switch (status) {
            case IGNORED: {
                return "\u2753 Ignored";
            }
            case FAILED: {
                return "\u274c **Failed**";
            }
            case SUCCESS: {
                return "\u2705\ufe0f Success";
            }
            case TIMEOUT: {
                return "\ud83d\udd51 **Timeout**";
            }
        }
        return "Unknown status";
    }
}

