/*
 * Decompiled with CFR 0.152.
 */
package com.github.guillaumederval.javagrading;

import com.github.guillaumederval.javagrading.CustomGradingResult;
import com.github.guillaumederval.javagrading.Format;
import com.github.guillaumederval.javagrading.Grade;
import com.github.guillaumederval.javagrading.GradeClass;
import com.github.guillaumederval.javagrading.GradeFeedback;
import com.github.guillaumederval.javagrading.GradeFeedbacks;
import com.github.guillaumederval.javagrading.TestStatus;
import com.github.guillaumederval.javagrading.utils.NaturalOrderComparator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.TestTimedOutException;

public class GradingListener
extends RunListener {
    private HashMap<Class, GradedClass> classes;
    private boolean outputAsRST;

    public GradingListener() {
        this.outputAsRST = true;
    }

    public GradingListener(boolean outputAsRST) {
        this.outputAsRST = outputAsRST;
    }

    private GradedClass getGradedClassObj(Class cls) {
        if (this.classes.containsKey(cls)) {
            return this.classes.get(cls);
        }
        double totalValue = -1.0;
        double defaultValue = -1.0;
        boolean allCorrect = false;
        GradeClass gc = cls.getAnnotation(GradeClass.class);
        if (gc != null) {
            totalValue = gc.totalValue();
            defaultValue = gc.defaultValue();
            allCorrect = gc.allCorrect();
        }
        GradedClass gco = new GradedClass(cls, totalValue, defaultValue, allCorrect);
        this.classes.put(cls, gco);
        return gco;
    }

    private boolean shouldBeGraded(Description desc) {
        return desc.getAnnotation(Grade.class) != null || desc.getTestClass().getAnnotation(GradeClass.class) != null;
    }

    private void addTestResult(Description description, TestStatus status, double customGrade, Throwable possibleException, String customFeedback, boolean isCustom) {
        if (!this.shouldBeGraded(description)) {
            return;
        }
        GradedClass gc = this.getGradedClassObj(description.getTestClass());
        double maxGrade = gc.defaultValue;
        Grade g = (Grade)description.getAnnotation(Grade.class);
        if (isCustom && !g.custom()) {
            System.out.println("WARNING: Received a CustomGradingResult exception while not expecting one.");
            System.out.println("If you are trying to solve this exercise: sadly, there is a protection against this ;-)");
            System.out.println("If you are the exercise creator, you probably forgot to put custom=true inside @Grade.");
            status = TestStatus.FAILED;
            customGrade = Double.NaN;
            possibleException = null;
        }
        if (g != null) {
            maxGrade = g.value();
        }
        if (maxGrade == -1.0) {
            return;
        }
        double grade = 0.0;
        if (!isCustom || Double.isNaN(customGrade)) {
            if (status == TestStatus.SUCCESS) {
                grade = maxGrade;
            }
        } else {
            grade = customGrade;
        }
        gc.add(description, grade, maxGrade, status, possibleException, customFeedback);
    }

    private void addTestResult(Description description, CustomGradingResult customGradingResult) {
        this.addTestResult(description, customGradingResult.status, customGradingResult.grade, customGradingResult.origException, customGradingResult.feedback, true);
    }

    private void addTestResult(Description description, TestStatus status, Failure possibleFailure) {
        this.addTestResult(description, status, Double.NaN, possibleFailure == null ? null : possibleFailure.getException(), null, false);
    }

    public void testRunStarted(Description description) {
        this.classes = new HashMap();
    }

    public void testRunFinished(Result result) {
        System.out.println("--- GRADE ---");
        double grade = 0.0;
        double gradeWithoutIgnored = 0.0;
        double max = 0.0;
        double maxWithoutIgnored = 0.0;
        ArrayList<GradedClass> gcl = new ArrayList<GradedClass>(this.classes.values());
        gcl.sort(new NaturalOrderComparator());
        if (this.outputAsRST) {
            System.out.println(".. csv-table::\n    :header: \"Test\", \"Status\", \"Grade\", \"Comment\"\n    :widths: auto\n    ");
        }
        for (GradedClass c : gcl) {
            if (c.getMax(true) == 0.0) continue;
            c.printStatus();
            grade += c.getGrade(true);
            max += c.getMax(true);
            gradeWithoutIgnored += c.getGrade(false);
            maxWithoutIgnored += c.getMax(false);
        }
        if (this.outputAsRST) {
            System.out.println("    \"**TOTAL**\",,**" + Format.format(grade) + "/" + Format.format(max) + "**");
            System.out.println("    \"**TOTAL WITHOUT IGNORED**\",,**" + Format.format(gradeWithoutIgnored) + "/" + Format.format(maxWithoutIgnored) + "**");
            System.out.println();
        }
        System.out.println("TOTAL " + Format.format(grade) + "/" + Format.format(max));
        System.out.println("TOTAL WITHOUT IGNORED " + Format.format(gradeWithoutIgnored) + "/" + Format.format(maxWithoutIgnored));
        System.out.println("--- END GRADE ---");
    }

    public void testFinished(Description description) {
        this.addTestResult(description, TestStatus.SUCCESS, null);
    }

    public void testFailure(Failure failure) {
        if (failure.getException() instanceof TestTimedOutException) {
            this.addTestResult(failure.getDescription(), TestStatus.TIMEOUT, failure);
        } else if (failure.getException() instanceof CustomGradingResult) {
            this.addTestResult(failure.getDescription(), (CustomGradingResult)failure.getException());
        } else {
            this.addTestResult(failure.getDescription(), TestStatus.FAILED, failure);
        }
    }

    public void testAssumptionFailure(Failure failure) {
        this.addTestResult(failure.getDescription(), TestStatus.IGNORED, null);
    }

    public void testIgnored(Description description) {
        this.addTestResult(description, TestStatus.IGNORED, null);
    }

    class GradedClass {
        private final Class cls;
        private final double totalValue;
        final double defaultValue;
        private final boolean allCorrect;
        private final HashMap<Description, GradedTest> grades;

        GradedClass(Class cls, double totalValue, double defaultValue, boolean allCorrect) {
            this.cls = cls;
            this.totalValue = totalValue;
            this.defaultValue = defaultValue;
            this.allCorrect = allCorrect;
            this.grades = new HashMap();
        }

        void add(Description desc, double grade, double maxGrade, TestStatus status, Throwable possibleException, String customFeedback) {
            if (!this.grades.containsKey(desc)) {
                this.grades.put(desc, new GradedTest(desc, grade, maxGrade, status, possibleException, customFeedback));
            }
        }

        double getPonderationRatio() {
            GradeResult gradeResult = this.getGradeResult();
            double realMax = gradeResult.maxGrade;
            if (realMax == 0.0) {
                return 0.0;
            }
            double destRealMax = this.totalValue;
            if (destRealMax == -1.0) {
                destRealMax = realMax;
            }
            return destRealMax / realMax;
        }

        double getMax(boolean includingIgnored) {
            GradeResult gradeResult = this.getGradeResult();
            double realMax = gradeResult.maxGrade;
            if (realMax == 0.0) {
                return 0.0;
            }
            double destRealMax = this.totalValue;
            if (destRealMax == -1.0) {
                destRealMax = realMax;
            }
            if (includingIgnored) {
                return destRealMax;
            }
            double notIgnoredRatio = gradeResult.maxGradeWithoutIgnored / gradeResult.maxGrade;
            return destRealMax * notIgnoredRatio;
        }

        double getGrade(boolean includingIgnored) {
            double destRealMax;
            GradeResult gradeResult = this.getGradeResult();
            double realMax = gradeResult.maxGrade;
            if (realMax == 0.0) {
                return 0.0;
            }
            if (this.allCorrect) {
                if (includingIgnored && !gradeResult.allIsSuccess) {
                    return 0.0;
                }
                if (!includingIgnored && !gradeResult.allIsSuccessOrIgnore) {
                    return 0.0;
                }
            }
            if ((destRealMax = this.totalValue) == -1.0) {
                destRealMax = realMax;
            }
            return gradeResult.grade * destRealMax / realMax;
        }

        private GradeResult getGradeResult() {
            GradeResult r = new GradeResult();
            for (GradedTest t : this.grades.values()) {
                r.allIsSuccess = r.allIsSuccess & t.status == TestStatus.SUCCESS;
                r.allIsSuccessOrIgnore = r.allIsSuccessOrIgnore & (t.status == TestStatus.SUCCESS || t.status == TestStatus.IGNORED);
                r.grade += t.grade;
                r.maxGrade += t.maxGrade;
                if (t.status == TestStatus.IGNORED) continue;
                r.maxGradeWithoutIgnored += t.maxGrade;
            }
            return r;
        }

        private void printStatusText() {
            System.out.println("- " + this.cls.toString() + " " + Format.format(this.getGrade(true)) + "/" + Format.format(this.getMax(true)));
            ArrayList<GradedTest> gcl = new ArrayList<GradedTest>(this.grades.values());
            gcl.sort(new NaturalOrderComparator());
            for (GradedTest t : gcl) {
                System.out.println(Format.prefix(t.toString(this.getPonderationRatio()), "\t"));
            }
        }

        private void printStatusRST() {
            String out = "    " + Format.csvEscape("**" + this.cls.toString() + "**") + ",,**" + Format.format(this.getGrade(true)) + "/" + Format.format(this.getMax(true)) + "**";
            System.out.println(out);
            ArrayList<GradedTest> gcl = new ArrayList<GradedTest>(this.grades.values());
            gcl.sort(new NaturalOrderComparator());
            for (GradedTest t : gcl) {
                System.out.println(Format.prefix(t.toString(this.getPonderationRatio()), "    "));
            }
        }

        void printStatus() {
            if (GradingListener.this.outputAsRST) {
                this.printStatusRST();
            } else {
                this.printStatusText();
            }
        }

        public String toString() {
            return this.cls.toString();
        }

        class GradeResult {
            double grade = 0.0;
            double maxGrade = 0.0;
            double maxGradeWithoutIgnored = 0.0;
            boolean allIsSuccess = true;
            boolean allIsSuccessOrIgnore = true;

            GradeResult() {
            }
        }
    }

    class GradedTest {
        final double grade;
        final double maxGrade;
        final TestStatus status;
        private final Description desc;
        private final Throwable possibleException;
        private final String customFeedback;

        GradedTest(Description desc, double grade, double maxGrade, TestStatus status, Throwable possibleException, String customFeedback) {
            this.maxGrade = maxGrade;
            this.grade = grade;
            this.status = status;
            this.desc = desc;
            this.possibleException = possibleException;
            this.customFeedback = customFeedback;
        }

        private String toStringText(double ratio) {
            StringBuilder out = new StringBuilder(this.desc.getDisplayName()).append(" ").append((Object)this.status).append(" ").append(Format.format(this.grade * ratio)).append("/").append(Format.format(this.maxGrade * ratio));
            this.processGradeFeedbacks(s -> out.append("\n").append(Format.prefix(s, "\t")));
            return out.toString();
        }

        private String toRSTCSVTableLine(double ratio) {
            StringBuilder out = new StringBuilder(Format.csvEscape("**\u2192** " + this.desc.getDisplayName())).append(",").append(Format.statusToIcon(this.status)).append(",").append(Format.format(this.grade * ratio)).append("/").append(Format.format(this.maxGrade * ratio));
            ArrayList fts = new ArrayList();
            this.processGradeFeedbacks(fts::add);
            if (fts.size() != 0) {
                out.append(",").append(Format.csvEscape(String.join((CharSequence)"\n\n", fts)));
            }
            return out.toString();
        }

        public String toString() {
            return this.toString(1.0);
        }

        public String toString(double ratio) {
            if (GradingListener.this.outputAsRST) {
                return this.toRSTCSVTableLine(ratio);
            }
            return this.toStringText(ratio);
        }

        private void processGradeFeedbacks(Consumer<String> op) {
            if (this.customFeedback == null) {
                GradeFeedback feedback = (GradeFeedback)this.desc.getAnnotation(GradeFeedback.class);
                GradeFeedbacks feedbacks = (GradeFeedbacks)this.desc.getAnnotation(GradeFeedbacks.class);
                if (feedback != null && this.shouldDisplayFeedback(feedback)) {
                    op.accept(this.formatFeedback(feedback.message()));
                }
                if (feedbacks != null) {
                    for (GradeFeedback f : feedbacks.value()) {
                        if (!this.shouldDisplayFeedback(f)) continue;
                        op.accept(this.formatFeedback(f.message()));
                    }
                }
            } else {
                op.accept(this.customFeedback);
            }
        }

        private boolean shouldDisplayFeedback(GradeFeedback f) {
            boolean show = !f.onFail() && !f.onIgnore() && !f.onSuccess() && !f.onTimeout() && (this.status == TestStatus.FAILED || this.status == TestStatus.TIMEOUT);
            show |= f.onSuccess() && this.status == TestStatus.SUCCESS;
            show |= f.onFail() && this.status == TestStatus.FAILED;
            show |= f.onTimeout() && this.status == TestStatus.TIMEOUT;
            return show |= f.onIgnore() && this.status == TestStatus.IGNORED;
        }

        private String formatFeedback(String feedback) {
            if (this.possibleException != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                this.possibleException.printStackTrace(writer);
                String trace = stringWriter.toString();
                return Format.replace(Format.replace(feedback, "$trace", trace), "$exception", this.possibleException.toString());
            }
            return feedback;
        }
    }
}

