/*
 * Decompiled with CFR 0.152.
 */
package com.github.guillaumederval.javagrading;

import com.github.guillaumederval.javagrading.Grade;
import com.github.guillaumederval.javagrading.GradeClass;
import com.github.guillaumederval.javagrading.TestSecurityManager;
import com.github.guillaumederval.javagrading.utils.PrintPermission;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;

class GradingRunnerUtils {
    GradingRunnerUtils() {
    }

    static Statement methodInvoker(FrameworkMethod method, Statement base) {
        return GradingRunnerUtils.cpu(method, GradingRunnerUtils.jail(method, base));
    }

    static Statement methodBlock(FrameworkMethod method, Statement base) {
        return base;
    }

    static Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        Test annoTest = (Test)method.getAnnotation(Test.class);
        Grade annoGrade = (Grade)method.getAnnotation(Grade.class);
        GradeClass annoGradeClass = method.getDeclaringClass().getAnnotation(GradeClass.class);
        long timeout = 0L;
        if (annoTest != null) {
            timeout = annoTest.timeout();
        }
        if (annoGrade != null && timeout == 0L && annoGrade.cpuTimeout() > 0L) {
            timeout = annoGrade.cpuTimeout() * 3L;
        }
        if (annoGradeClass != null && timeout == 0L && annoGradeClass.defaultCpuTimeout() > 0L) {
            timeout = annoGradeClass.defaultCpuTimeout() * 3L;
        }
        if (timeout <= 0L) {
            return next;
        }
        return FailOnTimeout.builder().withTimeout(timeout, TimeUnit.MILLISECONDS).build(next);
    }

    private static Statement cpu(final FrameworkMethod method, final Statement base) {
        boolean debug;
        Grade g = (Grade)method.getAnnotation(Grade.class);
        GradeClass gc = method.getDeclaringClass().getAnnotation(GradeClass.class);
        long cpuTimeout = 0L;
        if (g != null && g.cpuTimeout() > 0L) {
            cpuTimeout = g.cpuTimeout();
        }
        if (gc != null && cpuTimeout == 0L && gc.defaultCpuTimeout() > 0L) {
            cpuTimeout = gc.defaultCpuTimeout();
        }
        final long cpuTimeoutFinal = cpuTimeout;
        boolean bl = debug = g != null && g.debug();
        if (cpuTimeoutFinal > 0L) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    ThreadMXBean thread = ManagementFactory.getThreadMXBean();
                    long start = thread.getCurrentThreadCpuTime();
                    base.evaluate();
                    long end = thread.getCurrentThreadCpuTime();
                    if (debug) {
                        System.out.println("Function " + method.toString() + " took " + (end - start) / 1000000L + "ms");
                    }
                    if (end - start > cpuTimeoutFinal * 1000000L) {
                        throw new TestTimedOutException(cpuTimeoutFinal, TimeUnit.MILLISECONDS);
                    }
                }
            };
        }
        return base;
    }

    private static Statement jail(FrameworkMethod method, final Statement base) {
        GradingRunnerUtils.checkSecurity();
        Grade g = (Grade)method.getAnnotation(Grade.class);
        PermissionCollection coll = null;
        if (g != null) {
            try {
                coll = g.customPermissions().getConstructor(new Class[0]).newInstance(new Object[0]).get();
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (coll == null) {
            coll = new Permissions();
        }
        if (g != null && g.debug()) {
            ((PermissionCollection)coll).add(PrintPermission.instance);
        }
        final ProtectionDomain pd = new ProtectionDomain(new CodeSource(null, (Certificate[])null), coll);
        return new Statement(){

            public void evaluate() throws Throwable {
                Throwable ex = AccessController.doPrivileged(new PrivilegedExceptionAction<Throwable>(){

                    @Override
                    public Throwable run() throws Exception {
                        Throwable ex = null;
                        try {
                            base.evaluate();
                        }
                        catch (Throwable throwable) {
                            ex = throwable;
                        }
                        return ex;
                    }
                }, new AccessControlContext(new ProtectionDomain[]{pd}));
                if (ex != null) {
                    throw ex;
                }
            }
        };
    }

    private static void checkSecurity() {
        if (!(System.getSecurityManager() instanceof TestSecurityManager)) {
            try {
                System.setSecurityManager(new TestSecurityManager());
            }
            catch (SecurityException e) {
                System.out.println("/!\\ WARNING: Cannot set a TestSecurityManager as the security manager. Tests may not be jailed properly.");
            }
        }
    }
}

