/*
 * Decompiled with CFR 0.152.
 */
package com.github.guillaumederval.javagrading.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class NaturalOrderComparator
implements Comparator {
    private final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private final String getChunk(String s, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c = s.charAt(marker);
        chunk.append(c);
        ++marker;
        if (this.isDigit(c)) {
            while (marker < slength && this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < slength && !this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    public int compare(Object s1o, Object s2o) {
        String s1 = s1o.toString();
        String s2 = s2o.toString();
        if (s1 == null || s2 == null) {
            return 0;
        }
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            int result = 0;
            if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = thisChunk.compareTo(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    public static void main(String[] args) {
        List<String> values = Arrays.asList("dazzle2", "dazzle10", "dazzle1", "dazzle2.7", "dazzle2.10", "2", "10", "1", "EctoMorph6", "EctoMorph62", "EctoMorph7");
        System.out.println((Object)values.stream().sorted(new NaturalOrderComparator()).collect(Collectors.joining(" ")));
    }
}

