/*
 * Decompiled with CFR 0.152.
 */
package com.github.guillaumederval.javagrading.utils;

import com.github.guillaumederval.javagrading.utils.PrintPermission;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class PermissionStream
extends OutputStream {
    PrintStream parent;
    boolean warned;

    public PermissionStream(PrintStream parent) {
        this.parent = parent;
        this.warned = false;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.check()) {
            return;
        }
        this.parent.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.check()) {
            return;
        }
        this.parent.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.check()) {
            return;
        }
        this.parent.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (!this.check()) {
            return;
        }
        this.parent.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.check()) {
            return;
        }
        this.parent.close();
    }

    private boolean check() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(PrintPermission.instance);
            }
            catch (SecurityException e) {
                if (!this.warned) {
                    this.warned = true;
                    this.parent.println("WARNING:");
                    this.parent.println("You use print/println/write on System.out or System.err.");
                    this.parent.println("It won't work here and slows down your code a lot. Consider removing/commenting these calls.");
                    this.parent.println();
                }
                return false;
            }
        }
        return true;
    }
}

