/*
 * Decompiled with CFR 0.152.
 */
package com.github.gustavovitor.util;

import java.text.MessageFormat;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Configuration
public class MessageUtil {
    public static String getMessage(String code, String ... parameters) {
        return MessageFormat.format(MessageUtil.messageSource().getMessage(code, null, Locale.getDefault()), parameters);
    }

    @Bean
    public static MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("messages");
        messageSource.setDefaultEncoding("UTF-8");
        messageSource.setCacheSeconds(1);
        return messageSource;
    }
}

