/*
 * Decompiled with CFR 0.152.
 */
package com.github.mc.msql;

import com.github.mc.msql.CreateStatement;
import com.github.mc.msql.TableAttribute;
import com.github.mc.msql.annotations.MDelete;
import com.github.mc.msql.annotations.MInsert;
import com.github.mc.msql.annotations.MSelect;
import com.github.mc.msql.annotations.MUpdate;
import com.github.mc.msql.utils.PackageUtil;
import com.github.mc.msql.utils.Utils;
import java.util.List;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

final class MSqlStart {
    private static final Logger logger = LoggerFactory.getLogger(MSqlStart.class);
    private static final ClassPool pool = ClassPool.getDefault();

    MSqlStart() {
    }

    static void scan(String[] value, boolean showSentence) {
        for (String s : value) {
            if (!StringUtils.hasText((String)s)) continue;
            MSqlStart.scan(s, showSentence);
        }
    }

    private static void scan(String value, boolean showSentence) {
        try {
            List<String> classNames = PackageUtil.getClassName(value);
            for (String className : classNames) {
                MSqlStart.mapperScan(className, showSentence);
            }
        }
        catch (Exception e) {
            logger.error("Msql\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
    }

    private static void mapperScan(String classname, boolean showSentence) throws Exception {
        CtClass cc = pool.get(classname);
        CtMethod[] methods = cc.getDeclaredMethods();
        boolean ism = false;
        for (CtMethod method : methods) {
            MDelete mDelete;
            MSelect mSelect;
            MUpdate mUpdate;
            MInsert mInsert = (MInsert)method.getAnnotation(MInsert.class);
            if (mInsert != null) {
                MSqlStart.foundInsert(method, mInsert);
                ism = true;
            }
            if ((mUpdate = (MUpdate)method.getAnnotation(MUpdate.class)) != null) {
                MSqlStart.foundUpdate(method, mUpdate);
                ism = true;
            }
            if ((mSelect = (MSelect)method.getAnnotation(MSelect.class)) != null) {
                MSqlStart.foundSelect(method, mSelect);
                ism = true;
            }
            if ((mDelete = (MDelete)method.getAnnotation(MDelete.class)) == null) continue;
            MSqlStart.foundDelete(method, mDelete);
            ism = true;
        }
        if (ism) {
            cc.toClass();
            if (showSentence) {
                CtMethod[] methods1;
                logger.info(cc.getName());
                for (CtMethod ctMethod : methods1 = cc.getDeclaredMethods()) {
                    Object[] annotations;
                    for (Object annotation : annotations = ctMethod.getAnnotations()) {
                        logger.info(annotation.toString());
                    }
                    logger.info(ctMethod.getName());
                }
            }
        }
    }

    private static void changeAnnotate(CtMethod method, String annotate, String sql) {
        Annotation[] annotations;
        MethodInfo info = method.getMethodInfo();
        ConstPool constpool = info.getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
        Annotation annot = Utils.foundAnnotation(constpool, annotate, sql);
        attr.addAnnotation(annot);
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)info.getAttribute("RuntimeVisibleAnnotations");
        for (Annotation annotation : annotations = annotationsAttribute.getAnnotations()) {
            if ("com.github.mc.msql.annotations.MInsert".equals(annotation.getTypeName()) || "com.github.mc.msql.annotations.MUpdate".equals(annotation.getTypeName()) || "com.github.mc.msql.annotations.MSelect".equals(annotation.getTypeName()) || "com.github.mc.msql.annotations.MDelete".equals(annotation.getTypeName())) continue;
            attr.addAnnotation(annotation);
        }
        info.addAttribute((AttributeInfo)attr);
    }

    private static void foundDelete(CtMethod method, MDelete mDelete) throws Exception {
        MSqlStart.checkValue(mDelete.value());
        TableAttribute tableAttribute = MSqlStart.iudTableAttribute(method, mDelete.value(), mDelete.pojo());
        MSqlStart.changeAnnotate(method, "org.apache.ibatis.annotations.Delete", CreateStatement.deleteSql(tableAttribute));
    }

    private static void foundSelect(CtMethod method, MSelect mSelect) throws Exception {
        MSqlStart.checkValue(mSelect.value());
        TableAttribute tableAttribute = MSqlStart.sTableAttribute(method, mSelect.value(), mSelect.pojo());
        tableAttribute.setRestricts(mSelect.restrict());
        tableAttribute.setGroups(mSelect.group());
        tableAttribute.setHavings(mSelect.having());
        tableAttribute.setOrders(mSelect.order());
        CtClass returnType = Utils.returnType(method);
        MSqlStart.changeAnnotate(method, "org.apache.ibatis.annotations.Select", CreateStatement.selectSql(tableAttribute, returnType));
    }

    private static void foundUpdate(CtMethod method, MUpdate mUpdate) throws Exception {
        MSqlStart.checkValue(mUpdate.value());
        TableAttribute tableAttribute = MSqlStart.iudTableAttribute(method, mUpdate.value(), mUpdate.pojo());
        MSqlStart.changeAnnotate(method, "org.apache.ibatis.annotations.Update", CreateStatement.updateSql(tableAttribute));
    }

    private static void foundInsert(CtMethod method, MInsert mInsert) throws Exception {
        MSqlStart.checkValue(mInsert.value());
        TableAttribute tableAttribute = MSqlStart.iudTableAttribute(method, mInsert.value(), mInsert.pojo());
        MSqlStart.changeAnnotate(method, "org.apache.ibatis.annotations.Insert", CreateStatement.insertSql(tableAttribute));
    }

    private static void checkValue(String[] values) throws Exception {
        if (values.length > 2) {
            Utils.twe();
        }
        for (String value : values) {
            MSqlStart.checkCase(value);
        }
    }

    private static void checkCase(String value) throws Exception {
        if (!value.equals("camel-case") && !value.equals("under-score-case")) {
            Utils.twe();
        }
    }

    private static TableAttribute iudTableAttribute(CtMethod method, String[] values, Class pojo) throws NotFoundException, ClassNotFoundException {
        CtClass[] parameterTypes = method.getParameterTypes();
        CtClass ctClass = !"java.lang.Object".equals(pojo.getName()) ? pool.get(pojo.getName()) : parameterTypes[0];
        return Utils.tableAttribute(ctClass, method, values);
    }

    private static TableAttribute sTableAttribute(CtMethod method, String[] values, Class pojo) throws NotFoundException, ClassNotFoundException {
        CtClass ctClass;
        CtClass[] parameterTypes = method.getParameterTypes();
        CtClass returnType = method.getReturnType();
        if (!"java.lang.Object".equals(pojo.getName())) {
            ctClass = pool.get(pojo.getName());
        } else if (!("java.util.Map".equals(returnType.getName()) || "int".equals(returnType.getName()) || "java.lang.Integer".equals(returnType.getName()))) {
            if ("java.util.List".equals(returnType.getName())) {
                String genericSignature = method.getGenericSignature();
                if (genericSignature == null) {
                    ctClass = parameterTypes[0];
                } else {
                    genericSignature = genericSignature.replaceAll("^\\((.*)\\)", "");
                    genericSignature = genericSignature.substring(17, genericSignature.length() - 3);
                    genericSignature = genericSignature.replace("/", ".");
                    ctClass = pool.get(genericSignature);
                }
            } else {
                ctClass = returnType;
            }
        } else {
            ctClass = parameterTypes[0];
        }
        return Utils.tableAttribute(ctClass, method, values);
    }

    static {
        pool.insertClassPath((ClassPath)new ClassClassPath(MSqlStart.class));
    }
}

