/*
 * Decompiled with CFR 0.152.
 */
package com.github.mc.msql.utils;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import org.springframework.boot.loader.jar.JarFile;

public class PackageUtil {
    public static List<String> getClassName(String packageName) throws Exception {
        return PackageUtil.getClassName(packageName, true);
    }

    public static List<String> getClassName(String packageName, boolean childPackage) throws Exception {
        String packagePath;
        List<String> fileNames = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null) {
            String type = url.getProtocol();
            if ("file".equals(type)) {
                fileNames = PackageUtil.getClassNameByFile(url.getPath(), null, childPackage);
            } else if ("jar".equals(type)) {
                fileNames = PackageUtil.getClassNameByJar(url.getPath(), childPackage);
            }
        } else {
            fileNames = PackageUtil.getClassNameByJars(((URLClassLoader)loader).getURLs(), packagePath, childPackage);
        }
        return fileNames;
    }

    private static List<String> getClassNameByFile(String filePath, List<String> className, boolean childPackage) {
        File[] childFiles;
        ArrayList<String> myClassName = new ArrayList<String>();
        File file = new File(filePath);
        for (File childFile : childFiles = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(PackageUtil.getClassNameByFile(childFile.getPath(), myClassName, childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            childFilePath = childFilePath.substring(childFilePath.indexOf("\\classes") + 9, childFilePath.lastIndexOf("."));
            childFilePath = childFilePath.replace("\\", ".");
            myClassName.add(childFilePath);
        }
        return myClassName;
    }

    private static List<String> getClassNameByJar(String jarPath, boolean childPackage) throws Exception {
        String packagePath;
        String jarFilePath;
        ArrayList<String> myClassName = new ArrayList<String>();
        String[] jarInfo = jarPath.split("!");
        String nestedJarFilePath = null;
        if (jarInfo.length == 2) {
            jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
            packagePath = jarInfo[1].substring(1);
        } else if (jarInfo.length == 3) {
            jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
            nestedJarFilePath = jarInfo[1].substring(1);
            packagePath = jarInfo[2].substring(1);
        } else {
            throw new Exception("\u6ca1\u6709\u5bf9\u5e94\u7684jar\u5305\u89e3\u6790\u6a21\u5757.");
        }
        JarFile jarFile = null;
        JarFile nestedJarFile = null;
        try {
            Enumeration entrys;
            jarFile = new JarFile(new File(jarFilePath));
            nestedJarFile = jarFile.getNestedJarFile(jarFile.getJarEntry(nestedJarFilePath));
            Enumeration enumeration = entrys = nestedJarFile == null ? jarFile.entries() : nestedJarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(entryName);
                    continue;
                }
                int index = entryName.lastIndexOf("/");
                String myPackagePath = index != -1 ? entryName.substring(0, index) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(entryName);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != jarFile) {
                jarFile.close();
            }
            if (null != nestedJarFile) {
                nestedJarFile.close();
            }
        }
        return myClassName;
    }

    private static List<String> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) throws Exception {
        ArrayList<String> myClassName = new ArrayList<String>();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(PackageUtil.getClassNameByJar(jarPath, childPackage));
            }
        }
        return myClassName;
    }
}

