/*
 * Decompiled with CFR 0.152.
 */
package com.github.mc.msql.utils;

import com.github.mc.msql.TableAttribute;
import com.github.mc.msql.annotations.MField;
import com.github.mc.msql.annotations.MID;
import com.github.mc.msql.annotations.MIgnore;
import com.github.mc.msql.annotations.MTable;
import java.util.LinkedHashMap;
import java.util.Map;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.ibatis.annotations.Param;

public class Utils {
    public static String UnderlineToHump(String para) {
        String[] a;
        StringBuilder result = new StringBuilder();
        for (String s : a = para.split("_")) {
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    private static String HumpToUnderline(String para) {
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString();
    }

    public static String HumpToUnderlineI(String para) {
        String s = Utils.HumpToUnderline(para).toLowerCase();
        if (s.charAt(0) == '_') {
            s = s.substring(1);
        }
        return s;
    }

    public static String HumpToUnderlineX(String para) {
        String s = Utils.HumpToUnderline(para).toUpperCase();
        if (s.charAt(0) == '_') {
            s = s.substring(1);
        }
        return s;
    }

    public static void twe() throws Exception {
        throw new Exception("sql\u8bed\u53e5\u89e3\u6790\u5931\u8d25");
    }

    public static String analyzeTableName(String s, String ss) {
        if (ss.equals("under-score-case")) {
            s = Utils.HumpToUnderlineI(s);
        }
        return s;
    }

    public static String analyzeFieldName(String s, String ss) {
        if (ss.equals("under-score-case")) {
            s = Utils.HumpToUnderlineI(s);
        }
        return s;
    }

    public static String getCode(CtClass ctClass) {
        String name = ctClass.getSimpleName() + "Code";
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        CtField code = null;
        try {
            code = ctClass.getDeclaredField(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (code == null) {
            name = null;
        }
        return name;
    }

    public static String[] getParamAnnotations(Object[][] parameterAnnotations) {
        String[] values = new String[parameterAnnotations.length];
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            values[i] = parameterAnnotations[i].length == 1 && parameterAnnotations[i][0] instanceof Param ? ((Param)parameterAnnotations[i][0]).value() : null;
        }
        return values;
    }

    public static Map<String, String> params(CtMethod method) throws ClassNotFoundException, NotFoundException {
        Object[][] parameterAnnotations = method.getParameterAnnotations();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        CtClass[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            CtField[] fields;
            if (parameterAnnotations[i].length == 1 && parameterAnnotations[i][0] instanceof Param) {
                params.put(((Param)parameterAnnotations[i][0]).value(), parameterTypes[i].getName());
                continue;
            }
            for (CtField field : fields = parameterTypes[i].getDeclaredFields()) {
                Object mIgnore = field.getAnnotation(MIgnore.class);
                if (mIgnore != null) continue;
                params.put(field.getName(), field.getType().getName());
            }
        }
        return params;
    }

    public static TableAttribute tableAttribute(CtClass ctClass, CtMethod method, String[] values) throws ClassNotFoundException, NotFoundException {
        TableAttribute tableAttribute = new TableAttribute();
        Object mTable = ctClass.getAnnotation(MTable.class);
        String table = ctClass.getSimpleName();
        if (mTable != null) {
            tableAttribute.setTable(new String[]{table, ((MTable)mTable).value()});
        } else {
            tableAttribute.setTable(new String[]{table, Utils.analyzeTableName(table, values[1])});
        }
        LinkedHashMap<String, String[]> principal_linkage = new LinkedHashMap<String, String[]>();
        LinkedHashMap<String, String[]> field = new LinkedHashMap<String, String[]>();
        Object[][] parameterAnnotations = method.getParameterAnnotations();
        CtClass[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            CtField[] fields;
            Param param = null;
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                if (!(parameterAnnotations[i][j] instanceof Param)) continue;
                param = (Param)parameterAnnotations[i][j];
                break;
            }
            if (param != null) {
                String value = param.value();
                if ("id".equals(value)) {
                    principal_linkage.put(value, new String[]{"id", parameterTypes[i].getName()});
                    continue;
                }
                field.put(value, new String[]{Utils.analyzeFieldName(value, values[0]), parameterTypes[i].getName()});
                continue;
            }
            for (CtField cField : fields = parameterTypes[i].getDeclaredFields()) {
                String value;
                Object mIgnore = cField.getAnnotation(MIgnore.class);
                boolean isFinal = Modifier.isFinal((int)cField.getModifiers());
                if (mIgnore != null || isFinal) continue;
                Object mID = cField.getAnnotation(MID.class);
                Object mField = cField.getAnnotation(MField.class);
                if (mID != null) {
                    value = ((MID)mID).value();
                    principal_linkage.put(cField.getName(), new String[]{value, parameterTypes[i].getName()});
                    continue;
                }
                if (mField != null) {
                    value = ((MField)mField).value();
                    field.put(cField.getName(), new String[]{value, parameterTypes[i].getName()});
                    continue;
                }
                value = cField.getName();
                if ("id".equals(value)) {
                    principal_linkage.put(value, new String[]{value, cField.getType().getName()});
                    continue;
                }
                field.put(value, new String[]{Utils.analyzeFieldName(value, values[0]), cField.getType().getName()});
            }
        }
        tableAttribute.setPrincipal_linkage(principal_linkage);
        tableAttribute.setField(field);
        return tableAttribute;
    }

    public static Annotation foundAnnotation(ConstPool constpool, String annotate, String sql) {
        Annotation annot = new Annotation(annotate, constpool);
        StringMemberValue[] StringMemberValues = new StringMemberValue[]{new StringMemberValue(sql, constpool)};
        ArrayMemberValue arrayMemberValue = new ArrayMemberValue(constpool);
        arrayMemberValue.setValue((MemberValue[])StringMemberValues);
        annot.addMemberValue("value", (MemberValue)arrayMemberValue);
        return annot;
    }

    public static CtClass returnType(CtMethod method) throws NotFoundException {
        return method.getReturnType();
    }
}

