/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzm55.maven.settings.building;

import com.github.gzm55.maven.settings.merge.ProjectSettingsMerger;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.building.FileSource;
import org.apache.maven.building.Source;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsProblem;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.building.SettingsProblemCollector;
import org.apache.maven.settings.building.SettingsSource;
import org.apache.maven.settings.building.StringSettingsSource;
import org.apache.maven.settings.io.SettingsParseException;
import org.apache.maven.settings.io.SettingsReader;
import org.apache.maven.settings.io.SettingsWriter;
import org.apache.maven.settings.validation.SettingsValidator;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Named(value="project-settings")
public class ProjectSettingsInjector
extends AbstractEventSpy {
    @Inject
    private Logger logger;
    @Inject
    private SettingsReader settingsReader;
    @Inject
    private SettingsWriter settingsWriter;
    @Inject
    private SettingsValidator settingsValidator;
    @Inject
    private RuntimeInformation rtInfo;
    private ProjectSettingsMerger settingsMerger = new ProjectSettingsMerger();
    private static final String PROJECT_SETTINGS_FILENAME = ".mvn/settings.xml";
    public static final String PROJECT_SETTINGS_SKIP_KEY = "skipProjectSettings";
    private static final String IDEA_VERSION_1 = "idea.version";
    private static final String IDEA_VERSION_2 = "idea.maven.embedder.version";
    private static final String IDEA_VERSION_3 = "idea.version2020.1.1";
    private static final String SKIP_IDE_INTEGRATION_KEY = "skipIdeIntegration";
    private List<SettingsProblem> injectingProblems;
    private boolean inIde = false;
    private boolean skipIdeIntegration = false;
    private String localRepo = null;
    private Boolean isMaven4 = null;

    public void onEvent(Object event) throws SettingsBuildingException {
        if (null == this.isMaven4) {
            this.isMaven4 = this.rtInfo.isMavenVersion("3.99");
            if (this.isMaven4.booleanValue()) {
                this.logger.debug("maven 4 supports project settings natively, skip extension project-settings-extension");
            }
        }
        if (this.isMaven4.booleanValue()) {
            return;
        }
        if (event instanceof SettingsBuildingResult && null != this.injectingProblems) {
            ((SettingsBuildingResult)event).getProblems().addAll(0, this.injectingProblems);
            this.injectingProblems = null;
            return;
        }
        if (event instanceof MavenExecutionRequest) {
            MavenExecutionRequest mavenExecutionRequest = (MavenExecutionRequest)event;
            Properties sysProps = mavenExecutionRequest.getSystemProperties();
            this.inIde = sysProps.containsKey(IDEA_VERSION_1) || sysProps.containsKey(IDEA_VERSION_2) || sysProps.containsKey(IDEA_VERSION_3);
            this.skipIdeIntegration = sysProps.containsKey(this.skipIdeIntegration);
            return;
        }
        if (event instanceof MavenExecutionResult && this.inIde && !this.skipIdeIntegration && null != this.localRepo) {
            MavenExecutionResult mavenExecutionResult = (MavenExecutionResult)event;
            if (mavenExecutionResult.hasExceptions()) {
                return;
            }
            this.logger.debug("Make IDE to identify the parent poms downloaded from custom repositories.");
            for (MavenProject p : mavenExecutionResult.getTopologicallySortedProjects()) {
                MavenProject parent = null;
                for (parent = p.getParent(); null != parent; parent = parent.getParent()) {
                    String statusFileRelPath;
                    File internalStatusFile;
                    if (null != parent.getFile()) continue;
                    String flagFileRelPath = parent.getGroupId().replace('.', File.separatorChar) + File.separatorChar + parent.getArtifactId() + File.separatorChar + parent.getVersion() + File.separatorChar + "_remote.repositories";
                    File internalFlagFile = new File(this.localRepo, flagFileRelPath);
                    if (internalFlagFile.exists()) {
                        try {
                            if (internalFlagFile.delete()) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("Remove _remote.repositories: " + internalFlagFile.getPath());
                                }
                            } else {
                                this.logger.warn("Failed to remove " + internalFlagFile.getPath());
                            }
                        }
                        catch (SecurityException exception) {
                            this.logger.warn("Unable to remove " + internalFlagFile.getPath() + ". {}", (Throwable)exception);
                        }
                    }
                    if (!(internalStatusFile = new File(this.localRepo, statusFileRelPath = parent.getGroupId().replace('.', File.separatorChar) + File.separatorChar + parent.getArtifactId() + File.separatorChar + parent.getVersion() + File.separatorChar + parent.getArtifactId() + "-" + parent.getVersion() + ".pom.lastUpdated")).exists()) continue;
                    try {
                        if (internalStatusFile.delete()) {
                            if (!this.logger.isDebugEnabled()) continue;
                            this.logger.debug("Remove _remote.repositories: " + internalStatusFile.getPath());
                            continue;
                        }
                        this.logger.warn("Failed to remove " + internalStatusFile.getPath());
                        continue;
                    }
                    catch (SecurityException exception) {
                        this.logger.warn("Unable to remove " + internalStatusFile.getPath() + ". {}", (Throwable)exception);
                    }
                }
            }
            return;
        }
        if (!(event instanceof SettingsBuildingRequest)) {
            return;
        }
        SettingsBuildingRequest request = (SettingsBuildingRequest)event;
        if (Boolean.parseBoolean(this.getProperty(request, PROJECT_SETTINGS_SKIP_KEY, "false"))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skip loading project settings.");
            }
            return;
        }
        String multiModuleProjectDirectory = this.getProperty(request.getSystemProperties(), "maven.multiModuleProjectDirectory");
        if (null == multiModuleProjectDirectory) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("property maven.multiModuleProjectDirectory is not set while searching project settings.xml.");
            }
            return;
        }
        File projectSettingsFile = new File(multiModuleProjectDirectory, PROJECT_SETTINGS_FILENAME);
        if (!projectSettingsFile.exists()) {
            return;
        }
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Reading project settings from " + projectSettingsFile.getPath());
        }
        Source projectSettingsSource = this.getSettingsSource(projectSettingsFile, null);
        Settings projectSettings = this.readSettings(projectSettingsSource, problems);
        if (this.rtInfo.isMavenVersion("(,3.9)")) {
            for (Server server : projectSettings.getServers()) {
                Xpp3Dom conf = (Xpp3Dom)server.getConfiguration();
                for (int i = conf.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = conf.getChild(i);
                    if (!"connectTimeout".equals(child.getName()) && !"requestTimeout".equals(child.getName())) continue;
                    conf.removeChild(i);
                    this.logger.debug(String.format("fix server %s config on maven<3.9, remove key %s", server.getId(), child.getName()));
                }
            }
        }
        Source globalSettingsSource = this.getSettingsSource(request.getGlobalSettingsFile(), (Source)request.getGlobalSettingsSource());
        Source userSettingsSource = this.getSettingsSource(request.getUserSettingsFile(), (Source)request.getUserSettingsSource());
        Source injectSource = null != userSettingsSource ? userSettingsSource : globalSettingsSource;
        Settings injectSettings = this.readSettings(injectSource, problems);
        this.settingsMerger.merge(projectSettings, injectSettings, "user-level");
        StringSettingsSource resultSource = this.writeSettings(projectSettings, "memory(:" + projectSettingsSource.getLocation() + (null == injectSource ? "" : ":" + injectSource.getLocation()) + ")");
        if (null == injectSource || null != userSettingsSource) {
            request.setUserSettingsFile(null).setUserSettingsSource((SettingsSource)resultSource);
        } else {
            request.setGlobalSettingsFile(null).setGlobalSettingsSource((SettingsSource)resultSource);
        }
        for (SettingsProblem problem : problems) {
            if (SettingsProblem.Severity.ERROR.compareTo((Enum)problem.getSeverity()) < 0) continue;
            throw new SettingsBuildingException(problems);
        }
        this.injectingProblems = problems.isEmpty() ? null : problems;
        this.localRepo = projectSettings.getLocalRepository();
        if (null == this.localRepo) {
            this.localRepo = this.getProperty(request.getSystemProperties(), "user.home") + File.separatorChar + ".m2" + File.separatorChar + "repository";
        }
    }

    private Source getSettingsSource(File settingsFile, Source settingsSource) {
        if (null != settingsSource) {
            return settingsSource;
        }
        if (null != settingsFile && settingsFile.exists()) {
            return new FileSource(settingsFile);
        }
        return null;
    }

    private Settings readSettings(final Source settingsSource, final List<SettingsProblem> problems) {
        Settings settings;
        if (settingsSource == null) {
            return new Settings();
        }
        SettingsProblemCollector problemsAdder = new SettingsProblemCollector(){

            public void add(SettingsProblem.Severity severity, String message, int line, int col, Exception cause) {
                if (line <= 0 && col <= 0 && cause instanceof SettingsParseException) {
                    SettingsParseException e = (SettingsParseException)cause;
                    line = e.getLineNumber();
                    col = e.getColumnNumber();
                }
                problems.add(new DefaultSettingsProblem(message, severity, settingsSource.getLocation(), line, col, cause));
            }
        };
        try {
            Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.settings.io.isStrict", Boolean.TRUE);
            try {
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
            }
            catch (SettingsParseException err) {
                options = Collections.singletonMap("org.apache.maven.settings.io.isStrict", Boolean.FALSE);
                settings = this.settingsReader.read(settingsSource.getInputStream(), options);
                problemsAdder.add(SettingsProblem.Severity.WARNING, err.getMessage(), 0, 0, (Exception)((Object)err));
            }
        }
        catch (SettingsParseException err) {
            problemsAdder.add(SettingsProblem.Severity.FATAL, "Non-parseable settings " + settingsSource.getLocation() + ": " + err.getMessage(), 0, 0, (Exception)((Object)err));
            return new Settings();
        }
        catch (IOException err) {
            problemsAdder.add(SettingsProblem.Severity.FATAL, "Non-readable settings " + settingsSource.getLocation() + ": " + err.getMessage(), -1, -1, (Exception)err);
            return new Settings();
        }
        this.settingsValidator.validate(settings, problemsAdder);
        return settings;
    }

    private StringSettingsSource writeSettings(Settings settings, String location) {
        StringWriter writer = new StringWriter(4096);
        try {
            this.settingsWriter.write((Writer)writer, null, settings);
            return new StringSettingsSource((CharSequence)writer.toString(), location);
        }
        catch (IOException err) {
            throw new IllegalStateException("Failed to serialize settings to memory", err);
        }
    }

    private String getProperty(Properties fromProperties, String key) {
        return this.getProperty(fromProperties, key, null);
    }

    private String getProperty(Properties fromProperties, String key, String def) {
        return null == fromProperties ? null : fromProperties.getProperty(key, def);
    }

    private String getProperty(SettingsBuildingRequest fromRequest, String key) {
        return this.getProperty(fromRequest, key, null);
    }

    private String getProperty(SettingsBuildingRequest fromRequest, String key, String def) {
        String val = this.getProperty(fromRequest.getUserProperties(), key);
        return null != val ? val : this.getProperty(fromRequest.getSystemProperties(), key, def);
    }
}

