/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzm55.maven.settings.merge;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.merge.MavenSettingsMerger;

public class ProjectSettingsMerger
extends MavenSettingsMerger {
    public void merge(Settings dominant, Settings recessive, String recessiveSourceLevel) {
        if (null == dominant || null == recessive) {
            return;
        }
        dominant.setLocalRepository(recessive.getLocalRepository());
        dominant.setInteractiveMode(recessive.isInteractiveMode());
        dominant.setUsePluginRegistry(recessive.isUsePluginRegistry());
        dominant.setOffline(recessive.isOffline());
        dominant.setProxies(new ArrayList());
        HashMap<String, Server> serverById = new HashMap<String, Server>();
        for (Server server : dominant.getServers()) {
            server.setUsername(null);
            server.setPassword(null);
            server.setPrivateKey(null);
            server.setPassphrase(null);
            server.setFilePermissions(null);
            server.setDirectoryPermissions(null);
            serverById.put(server.getId(), server);
        }
        for (Server server : recessive.getServers()) {
            if (!serverById.containsKey(server.getId())) continue;
            Server dominantServer = (Server)serverById.get(server.getId());
            dominantServer.setSourceLevel(recessiveSourceLevel);
            dominantServer.setUsername(server.getUsername());
            dominantServer.setPassword(server.getPassword());
            dominantServer.setPrivateKey(server.getPrivateKey());
            dominantServer.setPassphrase(server.getPassphrase());
            dominantServer.setFilePermissions(server.getFilePermissions());
            dominantServer.setDirectoryPermissions(server.getDirectoryPermissions());
        }
        super.merge(dominant, recessive, recessiveSourceLevel);
    }
}

