/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.osjava.sj.loader.JndiLoader;
import org.osjava.sj.loader.util.Utils;

public class SimpleContext {
    public static final String SIMPLE_ROOT = "org.osjava.sj.root";
    public static final String SIMPLE_DELEGATE = "org.osjava.sj.factory";
    public static final String SIMPLE_SPACE = "org.osjava.sj.space";
    public static final String SIMPLE_SHARED = "org.osjava.sj.jndi.shared";
    private Hashtable environment;

    SimpleContext(Hashtable environment) {
        this.environment = environment;
        this.overwriteEnvironmentWithSystemProperties();
    }

    InitialContext loadRoot() throws NamingException {
        InitialContext initialContext;
        this.initializeStandardJndiEnvironment();
        String root = this.getRoot(this.environment);
        Context ctxt = initialContext = this.createInitialContext();
        ctxt = this.createENC(this.environment, ctxt);
        try {
            JndiLoader loader = new JndiLoader(this.environment);
            loader.loadDirectory(new File(root), ctxt);
        }
        catch (IOException ioe) {
            throw new NamingException("Unable to load data from directory: " + root + " due to error: " + ioe.getMessage());
        }
        return initialContext;
    }

    private Context createENC(Hashtable env, Context ctxt) throws NamingException {
        String space = (String)env.get(SIMPLE_SPACE);
        if (space != null) {
            String[] array;
            for (String anArray : array = Utils.split(space, (String)env.get("org.osjava.sj.delimiter"))) {
                ctxt = ctxt.createSubcontext(anArray);
            }
        }
        return ctxt;
    }

    private String getRoot(Hashtable env) {
        String root = (String)env.get(SIMPLE_ROOT);
        if (root == null) {
            throw new IllegalStateException("Property org.osjava.sj.root is mandatory. ");
        }
        if (root.startsWith("file://")) {
            root = root.substring("file://".length());
        }
        return root;
    }

    private void initializeStandardJndiEnvironment() {
        this.environment.put("jndi.syntax.direction", "left_to_right");
        if (!this.environment.containsKey("org.osjava.sj.delimiter")) {
            this.environment.put("org.osjava.sj.delimiter", ".");
        }
        this.environment.put("jndi.syntax.separator", this.environment.get("org.osjava.sj.delimiter"));
    }

    private InitialContext createInitialContext() throws NamingException {
        if (!this.environment.containsKey(SIMPLE_DELEGATE)) {
            this.environment.put(SIMPLE_DELEGATE, "org.osjava.sj.memory.MemoryContextFactory");
        }
        this.environment.put("java.naming.factory.initial", this.environment.get(SIMPLE_DELEGATE));
        return new InitialContext(this.environment);
    }

    private void overwriteEnvironmentWithSystemProperties() {
        this.overwriteFromSystemProperty("org.osjava.sj.delimiter");
        this.overwriteFromSystemProperty(SIMPLE_ROOT);
        this.overwriteFromSystemProperty(SIMPLE_SPACE);
        this.overwriteFromSystemProperty("org.osjava.sj.shared");
        this.overwriteFromSystemProperty(SIMPLE_DELEGATE);
    }

    private void overwriteFromSystemProperty(String key) {
        if (System.getProperty(key) != null) {
            this.environment.put(key, System.getProperty(key));
        }
    }
}

