/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.osjava.sj.SimpleContext;
import org.osjava.sj.jndi.DelegatingContext;

public class SimpleContextFactory
implements InitialContextFactory {
    private static final ConcurrentHashMap<String, DelegatingContext> contextsByRoot = new ConcurrentHashMap();

    public Context getInitialContext(Hashtable environment) throws NamingException {
        Boolean isShared = Boolean.valueOf((String)environment.get("org.osjava.sj.jndi.shared"));
        if (!isShared.booleanValue()) {
            return new SimpleContext(environment).loadRoot();
        }
        final String root = (String)environment.get("org.osjava.sj.root");
        Context ctx = contextsByRoot.get(root);
        if (ctx != null) {
            return ctx;
        }
        InitialContext context = new SimpleContext(environment).loadRoot();
        DelegatingContext delegatingContext = new DelegatingContext(context){

            @Override
            public void close() throws NamingException {
                contextsByRoot.remove(root);
                this.target.close();
            }
        };
        contextsByRoot.put(root, delegatingContext);
        return delegatingContext;
    }

    static void clearCache() {
        contextsByRoot.clear();
    }
}

