/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.io.FilenameUtils;
import org.osjava.sj.loader.JndiLoader;
import org.osjava.sj.loader.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJndi {
    public static final String SIMPLE_ROOT = "org.osjava.sj.root";
    public static final String CONTEXT_FACTORY = "org.osjava.sj.factory";
    public static final String SIMPLE_SPACE = "org.osjava.sj.space";
    public static final String SIMPLE_SHARED = "org.osjava.sj.jndi.shared";
    private static final Logger logger = LoggerFactory.getLogger(SimpleJndi.class);
    private Hashtable environment;

    SimpleJndi(Hashtable environment) {
        this.environment = environment;
        this.overwriteEnvironmentWithSystemProperties();
    }

    InitialContext loadRoot() throws NamingException {
        String[] roots;
        this.initializeStandardJndiEnvironment();
        InitialContext initialContext = this.createInitialContext();
        Context ctxt = initialContext;
        ctxt = this.createENC(this.environment, ctxt);
        String root = this.getRoot(this.environment);
        JndiLoader loader = new JndiLoader(this.environment);
        for (String path : roots = root.split(File.pathSeparator)) {
            File rootFile = new File(path);
            try {
                if (rootFile.isDirectory()) {
                    loader.loadDirectory(rootFile, ctxt);
                    continue;
                }
                if (rootFile.isFile()) {
                    Context tmpCtx = ctxt;
                    if (this.environment.containsKey("org.osjava.sj.filenameToContext")) {
                        tmpCtx = ctxt.createSubcontext(FilenameUtils.removeExtension((String)rootFile.getName()));
                    }
                    loader.load(loader.toProperties(rootFile), tmpCtx);
                    continue;
                }
                throw new NamingException("Unable to load data from " + rootFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new NamingException("Unable to load data from " + rootFile.getAbsolutePath() + " due to error: " + e.getMessage());
            }
        }
        return initialContext;
    }

    private Context createENC(Hashtable env, Context ctxt) throws NamingException {
        String space = (String)env.get(SIMPLE_SPACE);
        if (space != null) {
            String[] contextNames;
            for (String name : contextNames = Utils.split(space, (String)env.get("org.osjava.sj.delimiter"))) {
                ctxt = ctxt.createSubcontext(name);
            }
        }
        return ctxt;
    }

    private String getRoot(Hashtable env) {
        String root = (String)env.get(SIMPLE_ROOT);
        if (root == null) {
            throw new IllegalStateException("Property org.osjava.sj.root is mandatory. ");
        }
        if (root.startsWith("file://")) {
            root = root.substring("file://".length());
        }
        return root;
    }

    private void initializeStandardJndiEnvironment() {
        this.environment.put("jndi.syntax.direction", "left_to_right");
        if (!this.environment.containsKey("org.osjava.sj.delimiter")) {
            this.environment.put("org.osjava.sj.delimiter", ".");
        }
        this.environment.put("jndi.syntax.separator", this.environment.get("org.osjava.sj.delimiter"));
    }

    private InitialContext createInitialContext() throws NamingException {
        if (!this.environment.containsKey(CONTEXT_FACTORY)) {
            this.environment.put(CONTEXT_FACTORY, "org.osjava.sj.memory.MemoryContextFactory");
        }
        this.environment.put("java.naming.factory.initial", this.environment.get(CONTEXT_FACTORY));
        return new InitialContext(this.environment);
    }

    private void overwriteEnvironmentWithSystemProperties() {
        this.overwriteFromSystemProperty("org.osjava.sj.delimiter");
        this.overwriteFromSystemProperty(SIMPLE_ROOT);
        this.overwriteFromSystemProperty(SIMPLE_SPACE);
        this.overwriteFromSystemProperty("org.osjava.sj.shared");
        this.overwriteFromSystemProperty(CONTEXT_FACTORY);
    }

    private void overwriteFromSystemProperty(String key) {
        if (System.getProperty(key) != null) {
            this.environment.put(key, System.getProperty(key));
        }
    }
}

