/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingException;
import org.osjava.sj.loader.convert.ConvertRegistry;
import org.osjava.sj.loader.convert.Converter;
import org.osjava.sj.loader.util.AbstractProperties;
import org.osjava.sj.loader.util.CustomProperties;
import org.osjava.sj.loader.util.IniProperties;
import org.osjava.sj.loader.util.Utils;
import org.osjava.sj.loader.util.XmlProperties;

public class JndiLoader {
    public static final String SIMPLE_DELIMITER = "org.osjava.sj.delimiter";
    public static final String SIMPLE_COLON_REPLACE = "org.osjava.sj.colon.replace";
    private static ConvertRegistry convertRegistry = new ConvertRegistry();
    private Hashtable table = new Hashtable();

    public JndiLoader() {
        this.table.put(SIMPLE_DELIMITER, "/");
    }

    public JndiLoader(Hashtable env) {
        if (!env.containsKey(SIMPLE_DELIMITER)) {
            throw new IllegalArgumentException("The property org.osjava.sj.delimiter is mandatory. ");
        }
        this.table.put(SIMPLE_DELIMITER, env.get(SIMPLE_DELIMITER));
        if (env.containsKey(SIMPLE_COLON_REPLACE)) {
            this.table.put(SIMPLE_COLON_REPLACE, env.get(SIMPLE_COLON_REPLACE));
        }
    }

    public void loadDirectory(File directory, Context ctxt) throws NamingException, IOException {
        this.loadDirectory(directory, ctxt, null, "");
    }

    private void loadDirectory(File directory, Context ctxt, Context parentCtxt, String subName) throws NamingException, IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("java.io.File parameter must be a directory. [" + directory + "]");
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String[] extensions;
            String parentName = file.getName();
            String colonReplace = (String)this.table.get(SIMPLE_COLON_REPLACE);
            if (colonReplace != null && parentName.contains(colonReplace)) {
                parentName = Utils.replace(parentName, colonReplace, ":");
            }
            if (file.isDirectory()) {
                if (parentName.equals(".svn") || parentName.equals("CVS")) continue;
                Context tmpCtxt = ctxt.createSubcontext(parentName);
                this.loadDirectory(file, tmpCtxt, ctxt, parentName);
                continue;
            }
            for (String extension : extensions = new String[]{".properties", ".ini", ".xml"}) {
                if (!file.getName().endsWith(extension)) continue;
                Context subContext = ctxt;
                if (!file.getName().equals("default" + extension)) {
                    parentName = parentName.substring(0, parentName.length() - extension.length());
                    subContext = ctxt.createSubcontext(parentName);
                    parentCtxt = ctxt;
                    subName = parentName;
                }
                this.load(this.toProperties(file), subContext, parentCtxt, subName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties toProperties(File file) throws IOException {
        AbstractProperties p = file.getName().endsWith(".xml") ? new XmlProperties() : (file.getName().endsWith(".ini") ? new IniProperties() : new CustomProperties());
        p.setDelimiter((String)this.table.get(SIMPLE_DELIMITER));
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            p.load(fin);
            AbstractProperties abstractProperties = p;
            return abstractProperties;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
    }

    public void load(Properties properties, Context ctxt) throws NamingException {
        this.load(properties, ctxt, null, "");
    }

    public void load(Properties properties, Context subContext, Context parentCtxt, String subName) throws NamingException {
        HashMap<String, Properties> typeMap = new HashMap<String, Properties>();
        for (String string : properties.keySet()) {
            String type = this.extractTypeDeclaration(string);
            if (!string.equals("type") && type == null) continue;
            Properties tmp = new Properties();
            tmp.put("type", properties.get(string));
            if (string.equals("type")) {
                typeMap.put("datasourceOrBeanProperty", tmp);
                continue;
            }
            String keyWithoutType = string.substring(0, string.length() - type.length());
            typeMap.put(keyWithoutType, tmp);
        }
        for (String string : properties.keySet()) {
            Object value = properties.get(string);
            String delimiter = this.extractDelimiter(string);
            if (string.equals("type") || this.extractTypeDeclaration(string) != null) continue;
            if (typeMap.containsKey("datasourceOrBeanProperty")) {
                ((Properties)typeMap.get("datasourceOrBeanProperty")).put(string, value);
                continue;
            }
            if (typeMap.containsKey(string)) {
                ((Properties)typeMap.get(string)).put("valueToConvert", value);
                continue;
            }
            if (delimiter != null) {
                String pathText = JndiLoader.removeLastElement(string, delimiter);
                String nodeText = JndiLoader.getLastElement(string, delimiter);
                if (typeMap.containsKey(pathText)) {
                    ((Properties)typeMap.get(pathText)).put(nodeText, value);
                    continue;
                }
                this.jndiPut(subContext, string, value);
                continue;
            }
            this.jndiPut(subContext, string, value);
        }
        for (Object key : typeMap.keySet()) {
            String typeKey = (String)key;
            Properties typeProperties = (Properties)typeMap.get(typeKey);
            Object value = JndiLoader.convert(typeProperties);
            if (typeKey.equals("datasourceOrBeanProperty")) {
                parentCtxt.rebind(subName, value);
                continue;
            }
            this.jndiPut(subContext, typeKey, value);
        }
    }

    private String extractDelimiter(String key) {
        Pattern pattern;
        Matcher matcher;
        String delimiter = (String)this.table.get(SIMPLE_DELIMITER);
        if (delimiter.length() == 1) {
            delimiter = delimiter.replace(".", "\\.");
        }
        if ((matcher = (pattern = Pattern.compile("^.+(" + delimiter + ").+")).matcher(key)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String extractTypeDeclaration(String key) {
        String delimiter = (String)this.table.get(SIMPLE_DELIMITER);
        if (delimiter.length() == 1) {
            delimiter = delimiter.replace(".", "\\.");
        }
        Pattern pattern = Pattern.compile(".+((?:" + delimiter + ")type)$");
        Matcher matcher = pattern.matcher(key);
        String type = null;
        if (matcher.find()) {
            type = matcher.group(1);
        }
        return type;
    }

    private void jndiPut(Context ctxt, String key, Object value) throws NamingException {
        String[] pathParts = Utils.split(key, (String)this.table.get(SIMPLE_DELIMITER));
        Context deepestContext = this.createSubContexts(pathParts, ctxt);
        deepestContext.bind(pathParts[pathParts.length - 1], value);
    }

    private Context createSubContexts(String[] path, Context parentContext) throws NamingException {
        int lastIndex = path.length - 1;
        Context currentCtx = parentContext;
        for (int i = 0; i < lastIndex; ++i) {
            Object obj = currentCtx.lookup(path[i]);
            if (obj == null) {
                currentCtx = currentCtx.createSubcontext(path[i]);
                continue;
            }
            if (obj instanceof Context) {
                currentCtx = (Context)obj;
                continue;
            }
            throw new RuntimeException("Illegal node/branch clash. At branch value '" + path[i] + "' an Object was found: " + obj);
        }
        return currentCtx;
    }

    private static Object convert(Properties properties) {
        String type = properties.getProperty("type");
        String converterClassName = properties.getProperty("converter");
        if (converterClassName != null) {
            try {
                Class<?> converterClass = Class.forName(converterClassName);
                Converter converter = (Converter)converterClass.newInstance();
                return converter.convert(properties, type);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to find class: " + converterClassName, cnfe);
            }
            catch (IllegalAccessException ie) {
                throw new RuntimeException("Unable to access class: " + type, ie);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException("Unable to create Converter " + type + " via empty constructor. ", ie);
            }
        }
        Converter converter = convertRegistry.getConverter(type);
        if (converter != null) {
            Object values = properties.get("valueToConvert");
            if (values instanceof List) {
                List vals = (List)values;
                LinkedList<Object> converted = new LinkedList<Object>();
                for (String val : vals) {
                    Properties p = new Properties();
                    p.setProperty("valueToConvert", val);
                    converted.add(converter.convert(p, type));
                }
                return converted;
            }
            return converter.convert(properties, type);
        }
        return properties.get("valueToConvert");
    }

    private static String getLastElement(String str, String delimiter) {
        int idx = str.lastIndexOf(delimiter);
        return str.substring(idx + 1);
    }

    private static String removeLastElement(String str, String delimiter) {
        int idx = str.lastIndexOf(delimiter);
        return str.substring(0, idx);
    }
}

