/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.memory;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.osjava.sj.memory.MemoryContext;

public class MemoryContextFactory
implements InitialContextFactory {
    private static final ConcurrentHashMap<String, Context> contextsByRoot = new ConcurrentHashMap();

    public Context getInitialContext(Hashtable environment) throws NamingException {
        Boolean isShared = Boolean.valueOf((String)environment.get("org.osjava.sj.jndi.shared"));
        if (!isShared.booleanValue()) {
            return new MemoryContext(environment);
        }
        final String root = (String)environment.get("org.osjava.sj.root");
        Context ctx = contextsByRoot.get(root);
        if (ctx != null) {
            return ctx;
        }
        MemoryContext context = new MemoryContext(environment){

            @Override
            public void close() throws NamingException {
                contextsByRoot.remove(root);
                super.close();
            }
        };
        contextsByRoot.put(root, context);
        return context;
    }

    static void clearCache() {
        contextsByRoot.clear();
    }
}

