/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.osjava.sj.jndi.AbstractContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryContext
extends AbstractContext {
    private static Logger LOGGER = LoggerFactory.getLogger(MemoryContext.class);

    public MemoryContext() {
    }

    public MemoryContext(Hashtable env) {
        super(env);
    }

    public MemoryContext(Hashtable env, NameParser parser) {
        super(env, parser);
    }

    public MemoryContext(NameParser parser) {
        super(parser);
    }

    public MemoryContext(AbstractContext that) {
        super(that);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        Hashtable subContexts = this.getSubContexts();
        if (name.size() > 1) {
            if (subContexts.containsKey(name.getPrefix(1))) {
                Context subContext = (Context)subContexts.get(name.getPrefix(1));
                Context newContext = subContext.createSubcontext(name.getSuffix(1));
                return newContext;
            }
            throw new NameNotFoundException("The subcontext " + name.getPrefix(1) + " was not found (" + name + ").");
        }
        try {
            this.lookup(name);
        }
        catch (NameNotFoundException ignore) {
            // empty catch block
        }
        Name contextName = this.getNameParser((Name)null).parse(this.getNameInNamespace());
        contextName.addAll(name);
        MemoryContext newContext = new MemoryContext(this);
        ((AbstractContext)newContext).setNameInNamespace(contextName);
        this.bind(name, (Object)newContext);
        return newContext;
    }
}

