/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj;

import java.io.File;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.BooleanUtils;
import org.jetbrains.annotations.Nullable;
import org.osjava.StringUtils;
import org.osjava.sj.loader.JndiLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJndi {
    public static final String ROOT = "org.osjava.sj.root";
    public static final String CONTEXT_FACTORY = "org.osjava.sj.factory";
    public static final String ENC = "org.osjava.sj.space";
    public static final String SHARED = "org.osjava.sj.jndi.shared";
    public static final String JNDI_SYNTAX_SEPARATOR = "jndi.syntax.separator";
    private static final Logger logger = LoggerFactory.getLogger(SimpleJndi.class);
    public static final String FILENAME_TO_CONTEXT = "org.osjava.sj.filenameToContext";
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleJndi.class);
    private Hashtable<String, String> env;

    SimpleJndi(Hashtable<String, String> environment) {
        this.env = environment;
        this.overwriteEnvironmentWithSystemProperties();
    }

    InitialContext loadRoot() throws NamingException {
        InitialContext initialContext;
        this.initializeStandardJndiEnvironment();
        Context ctxt = initialContext = this.createInitialContext();
        ctxt = this.createENC(this.env, ctxt);
        JndiLoader loader = new JndiLoader(this.env);
        String root = this.getRoot(this.env);
        if (root != null && !root.isEmpty()) {
            String[] roots;
            for (String path : roots = root.split(File.pathSeparator)) {
                File rootFile = new File(path);
                LOGGER.debug("Loading {}", (Object)rootFile.getAbsolutePath());
                try {
                    loader.load(rootFile, ctxt, BooleanUtils.toBoolean((String)this.env.get(FILENAME_TO_CONTEXT)), true);
                }
                catch (Exception e) {
                    LOGGER.error("Unable to load: ", (Object)rootFile.getAbsolutePath(), (Object)e);
                    initialContext.close();
                    throw new NamingException("" + e.getMessage());
                }
            }
        } else {
            logger.warn("Mistakenly no root provided?");
        }
        return initialContext;
    }

    private Context createENC(Hashtable env, Context ctxt) throws NamingException {
        String space = (String)env.get(ENC);
        if (space != null) {
            String[] contextNames;
            String delimiter = (String)env.get("org.osjava.sj.delimiter");
            Object separator = env.get(JNDI_SYNTAX_SEPARATOR);
            if (separator != null && !separator.equals(delimiter)) {
                delimiter = "\\" + delimiter + "|\\" + separator;
            }
            for (String name : contextNames = StringUtils.split(space, delimiter)) {
                ctxt = ctxt.createSubcontext(name);
            }
        }
        return ctxt;
    }

    @Nullable
    private String getRoot(Hashtable env) {
        String root = (String)env.get(ROOT);
        if (root != null && root.startsWith("file://")) {
            root = root.substring("file://".length());
        }
        return root;
    }

    private void initializeStandardJndiEnvironment() {
        this.env.put("jndi.syntax.direction", "left_to_right");
        if (!this.env.containsKey("org.osjava.sj.delimiter")) {
            this.env.put("org.osjava.sj.delimiter", ".");
        }
        if (!this.env.containsKey(JNDI_SYNTAX_SEPARATOR)) {
            this.env.put(JNDI_SYNTAX_SEPARATOR, this.env.get("org.osjava.sj.delimiter"));
        }
    }

    private InitialContext createInitialContext() throws NamingException {
        if (!this.env.containsKey(CONTEXT_FACTORY)) {
            this.env.put(CONTEXT_FACTORY, "org.osjava.sj.MemoryContextFactory");
        }
        this.env.put("java.naming.factory.initial", this.env.get(CONTEXT_FACTORY));
        return new InitialContext(this.env);
    }

    private void overwriteEnvironmentWithSystemProperties() {
        this.overwriteFromSystemProperty(ROOT);
        this.overwriteFromSystemProperty(ENC);
        this.overwriteFromSystemProperty(CONTEXT_FACTORY);
        this.overwriteFromSystemProperty(SHARED);
        this.overwriteFromSystemProperty(JNDI_SYNTAX_SEPARATOR);
        this.overwriteFromSystemProperty(FILENAME_TO_CONTEXT);
        this.overwriteFromSystemProperty("org.osjava.sj.delimiter");
        this.overwriteFromSystemProperty("org.osjava.sj.colon.replace");
        this.overwriteFromSystemProperty("java.naming.factory.object");
    }

    private void overwriteFromSystemProperty(String key) {
        if (System.getProperty(key) != null) {
            this.env.put(key, System.getProperty(key));
        }
    }
}

