/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.osjava.sj.loader.convert.ConverterIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConverter
implements ConverterIF {
    private static Logger LOGGER = LoggerFactory.getLogger(BeanConverter.class);

    @Override
    public Object convert(Properties properties, String type) {
        String value = properties.getProperty("");
        if (value != null) {
            throw new RuntimeException("Specify the value as a pseudo property as Beans have empty constructors");
        }
        String methodName = null;
        try {
            Class<?> c = Class.forName(type);
            Object bean = c.newInstance();
            for (String string : properties.keySet()) {
                if ("converter".equals(string) || "type".equals(string)) continue;
                Object property = properties.get(string);
                if (property instanceof String) {
                    methodName = "set" + Character.toTitleCase(string.charAt(0)) + string.substring(1);
                    Method m = c.getMethod(methodName, String.class);
                    m.invoke(bean, property);
                    continue;
                }
                if (property instanceof List) {
                    List list = (List)property;
                    int sz = list.size();
                    String string2 = "add" + Character.toTitleCase(string.charAt(0)) + string.substring(1);
                    Method m = c.getMethod(string2, Integer.TYPE, String.class);
                    for (int i = 0; i < sz; ++i) {
                        Object item = list.get(i);
                        if (!(item instanceof String)) {
                            LOGGER.error("Processing List: properties={} type={} property={} key={} item={}", new Object[]{properties, type, property, string2, item});
                            throw new RuntimeException("Only Strings and Lists of String are supported");
                        }
                        m.invoke(bean, new Integer(i), item);
                    }
                    continue;
                }
                LOGGER.error("Processing List: properties={} type={} methodName={} property={} key={}", new Object[]{properties, type, methodName, property, string});
                throw new RuntimeException("Only Strings and Lists of Strings are supported");
            }
            return bean;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to find class: " + type, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find method " + methodName + " on class: " + type, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate class: " + type, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access class: " + type, e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unable to pass argument to class: " + type, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to invoke (String) constructor on class: " + type, e);
        }
    }
}

