/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.jndi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.lang.BooleanUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osjava.sj.jndi.ContextBindings;
import org.osjava.sj.jndi.ContextNames;
import org.osjava.sj.jndi.SimpleNameParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryContext
implements Cloneable,
Context {
    public static final String IGNORE_CLOSE = "org.osjava.sj.jndi.ignoreClose";
    private Map<Name, Object> namesToObjects = Collections.synchronizedMap(new HashMap());
    private Map<Name, Context> subContexts = Collections.synchronizedMap(new HashMap());
    private Hashtable env = new Hashtable();
    private NameParser nameParser;
    private Name nameInNamespace = null;
    private boolean nameLock = false;
    private static Logger LOGGER = LoggerFactory.getLogger(MemoryContext.class);

    public MemoryContext(Hashtable env) {
        this(env, null);
    }

    protected MemoryContext() {
        this(null, null);
        throw new RuntimeException("Not fully implemented");
    }

    protected MemoryContext(NameParser parser) {
        this(null, parser);
    }

    protected MemoryContext(Hashtable env, NameParser parser) {
        if (env != null) {
            this.env = (Hashtable)env.clone();
        }
        if (parser == null) {
            try {
                this.nameParser = new SimpleNameParser(this);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        try {
            this.nameInNamespace = this.nameParser.parse("");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "AbstractContext{namesToObjects=" + this.namesToObjects + ", subContexts=" + this.subContexts + ", env=" + this.env + ", nameParser=" + this.nameParser + ", nameInNamespace=" + this.nameInNamespace + ", nameLock=" + this.nameLock + '}';
    }

    @Override
    public Object lookup(@NotNull Name name) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(0);
        }
        if (name.size() == 0) {
            return this.newInstance();
        }
        Name objName = name.getPrefix(1);
        if (name.size() > 1) {
            if (this.subContexts.containsKey(objName)) {
                return this.subContexts.get(objName).lookup(name.getSuffix(1));
            }
            String msg = "AbstractContext#lookup(\"{}\"): Invalid subcontext '{}' in context '{}': {}";
            LOGGER.error(msg, new Object[]{name, objName, this.getNameInNamespace(), this});
            throw new NamingException();
        }
        if (this.namesToObjects.containsKey(name)) {
            return this.namesToObjects.get(objName);
        }
        if (this.subContexts.containsKey(name)) {
            return this.subContexts.get(name);
        }
        LOGGER.debug("AbstractContext#lookup() {} not found in {}", (Object)name, (Object)this);
        throw new NameNotFoundException(name.toString());
    }

    @Nullable
    private Object newInstance() throws OperationNotSupportedException {
        Context clone;
        try {
            clone = (Context)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new OperationNotSupportedException();
        }
        return clone;
    }

    @Override
    public Object lookup(@NotNull String name) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(1);
        }
        return this.lookup(this.nameParser.parse(name));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void bind(@NotNull Name name, @Nullable Object object) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(2);
        }
        if (name.size() == 0) {
            throw new InvalidNameException("Cannot bind to an empty name.");
        }
        if (name.size() > 1) {
            Name prefix = name.getPrefix(1);
            if (this.subContexts.containsKey(prefix)) {
                this.subContexts.get(prefix).bind(name.getSuffix(1), object);
                return;
            }
            LOGGER.error("No such subcontext: {} in {}", (Object)prefix, (Object)this);
            throw new NameNotFoundException(prefix + "");
        }
        if (this.namesToObjects.containsKey(name) || this.subContexts.containsKey(name)) {
            LOGGER.error("bind() {} already bound in {}", (Object)name, (Object)this);
            throw new NameAlreadyBoundException("Name " + name.toString() + " already bound.  Use rebind() to override");
        }
        if (object instanceof Context) {
            this.subContexts.put(name, (Context)object);
            return;
        }
        this.namesToObjects.put(name, object);
    }

    @Override
    public void bind(@NotNull String name, @Nullable Object object) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(3);
        }
        this.bind(this.nameParser.parse(name), object);
    }

    @Override
    public void rebind(@NotNull Name name, @Nullable Object object) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(4);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind to empty name");
        }
        Object targetContext = this.lookup(name.getPrefix(name.size() - 1));
        if (targetContext == null || !(targetContext instanceof Context)) {
            throw new NamingException("Cannot bind object.  Target context does not exist.");
        }
        this.unbind(name);
        this.bind(name, object);
    }

    @Override
    public void rebind(@NotNull String name, @Nullable Object object) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(5);
        }
        this.rebind(this.nameParser.parse(name), object);
    }

    @Override
    public void unbind(@NotNull Name name) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(6);
        }
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind to empty name");
        }
        if (name.size() == 1) {
            if (this.namesToObjects.containsKey(name)) {
                this.namesToObjects.remove(name);
            }
            if (this.subContexts.containsKey(name)) {
                this.subContexts.remove(name);
            }
        } else {
            Object targetContext = this.lookup(name.getPrefix(name.size() - 1));
            if (targetContext == null || !(targetContext instanceof Context)) {
                NamingException e = new NamingException("Cannot unbind object.");
                LOGGER.error("Can not unbind object with name={} from targetContext={}.", (Object)name, targetContext);
                LOGGER.error("", (Throwable)e);
                throw e;
            }
            ((Context)targetContext).unbind(name.getSuffix(name.size() - 1));
        }
    }

    @Override
    public void unbind(@NotNull String name) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(7);
        }
        this.unbind(this.nameParser.parse(name));
    }

    @Override
    public void rename(@NotNull Name oldName, @NotNull Name newName) throws NamingException {
        if (oldName == null) {
            MemoryContext.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            MemoryContext.$$$reportNull$$$0(9);
        }
        Object old = this.lookup(oldName);
        if (newName.isEmpty()) {
            throw new InvalidNameException("Cannot bind to empty name");
        }
        if (old == null) {
            throw new NamingException("Name '" + oldName + "' not found.");
        }
        if (this.lookup(newName) != null) {
            throw new NameAlreadyBoundException("Name '" + newName + "' already bound");
        }
        this.unbind(oldName);
        this.unbind(newName);
        this.bind(newName, old);
        if (old instanceof Thread) {
            ((Thread)old).setName(newName.toString());
        }
    }

    @Override
    public void rename(@NotNull String oldName, @NotNull String newName) throws NamingException {
        if (oldName == null) {
            MemoryContext.$$$reportNull$$$0(10);
        }
        if (newName == null) {
            MemoryContext.$$$reportNull$$$0(11);
        }
        this.rename(this.nameParser.parse(oldName), this.nameParser.parse(newName));
    }

    public NamingEnumeration list(@NotNull Name name) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(12);
        }
        if (name == null || name.isEmpty()) {
            HashMap<Name, Object> enumStore = new HashMap<Name, Object>();
            enumStore.putAll(this.namesToObjects);
            enumStore.putAll(this.subContexts);
            ContextNames enumerator = new ContextNames(enumStore);
            return enumerator;
        }
        Name subName = name.getPrefix(1);
        if (this.namesToObjects.containsKey(subName)) {
            throw new NotContextException(name + " cannot be listed");
        }
        if (this.subContexts.containsKey(subName)) {
            return this.subContexts.get(subName).list(name.getSuffix(1));
        }
        throw new NamingException();
    }

    public NamingEnumeration list(@NotNull String name) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(13);
        }
        return this.list(this.nameParser.parse(name));
    }

    public NamingEnumeration listBindings(@NotNull Name name) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(14);
        }
        if (name == null || name.isEmpty()) {
            HashMap<Name, Object> enumStore = new HashMap<Name, Object>();
            enumStore.putAll(this.namesToObjects);
            enumStore.putAll(this.subContexts);
            return new ContextBindings(enumStore);
        }
        Name subName = name.getPrefix(1);
        if (this.subContexts.containsKey(subName)) {
            return this.subContexts.get(subName).listBindings(name.getSuffix(1));
        }
        throw new NamingException("AbstractContext#listBindings(\"" + name + "\"): subcontext not found.");
    }

    public NamingEnumeration listBindings(@NotNull String name) throws NamingException {
        if (name == null) {
            MemoryContext.$$$reportNull$$$0(15);
        }
        return this.listBindings(this.nameParser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (name.size() > 1) {
            if (this.subContexts.containsKey(name.getPrefix(1))) {
                Context subContext = this.subContexts.get(name.getPrefix(1));
                this.destroySubcontexts(subContext);
                return;
            }
            throw new NameNotFoundException();
        }
        if (this.namesToObjects.containsKey(name)) {
            throw new NotContextException();
        }
        if (!this.subContexts.containsKey(name)) {
            throw new NameNotFoundException();
        }
        Context subContext = this.subContexts.get(name);
        this.destroySubcontexts(subContext);
        subContext.close();
        this.subContexts.remove(name);
    }

    private void destroySubcontexts(Context context) throws NamingException {
        NamingEnumeration<Binding> bindings = context.listBindings("");
        while (bindings.hasMore()) {
            Binding binding = bindings.next();
            String name = binding.getName();
            if (binding.getObject() instanceof Context) {
                Context subContext = (Context)binding.getObject();
                this.destroySubcontexts(subContext);
                context.destroySubcontext(name);
                continue;
            }
            LOGGER.trace("Unbind {}", (Object)name);
            Properties syntax = new Properties();
            syntax.setProperty("jndi.syntax.direction", "flat");
            context.unbind(new CompoundName(name, syntax));
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.nameParser.parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() > 1) {
            if (this.subContexts.containsKey(name.getPrefix(1))) {
                Context subContext = this.subContexts.get(name.getPrefix(1));
                Context newContext = subContext.createSubcontext(name.getSuffix(1));
                return newContext;
            }
            throw new NameNotFoundException("The subcontext " + name.getPrefix(1) + " was not found (" + name + ").");
        }
        try {
            this.lookup(name);
        }
        catch (NameNotFoundException ignore) {
            // empty catch block
        }
        Name contextName = this.getNameParser((Name)null).parse(this.getNameInNamespace());
        contextName.addAll(name);
        MemoryContext newContext = new MemoryContext(this.env);
        newContext.setNameInNamespace(contextName);
        this.bind(name, (Object)newContext);
        return newContext;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.nameParser.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(this.nameParser.parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (name == null || name.isEmpty() || name.size() == 1 && name.toString().equals(this.getNameInNamespace())) {
            return this.nameParser;
        }
        Name subName = name.getPrefix(1);
        if (this.subContexts.containsKey(subName)) {
            return this.subContexts.get(subName).getNameParser(name.getSuffix(1));
        }
        throw new NotContextException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(this.nameParser.parse(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (name == null || prefix == null) {
            throw new NamingException("Arguments must not be null");
        }
        Name retName = (Name)prefix.clone();
        retName.addAll(name);
        return retName;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name retName = this.composeName(this.nameParser.parse(name), this.nameParser.parse(prefix));
        return retName.toString();
    }

    @Override
    public Object addToEnvironment(String name, Object object) {
        if (this.env == null) {
            return null;
        }
        return this.env.put(name, object);
    }

    @Override
    public Object removeFromEnvironment(String name) {
        if (this.env == null) {
            return null;
        }
        return this.env.remove(name);
    }

    public Hashtable getEnvironment() {
        if (this.env == null) {
            return new Hashtable();
        }
        return (Hashtable)this.env.clone();
    }

    @Override
    public void close() throws NamingException {
        String ignoreClose = (String)this.env.get(IGNORE_CLOSE);
        if (!BooleanUtils.toBoolean((String)ignoreClose)) {
            this.forceClose();
        }
    }

    @Override
    public String getNameInNamespace() {
        return this.nameInNamespace.toString();
    }

    public boolean isEmpty() {
        return this.namesToObjects.size() > 0 || this.subContexts.size() > 0;
    }

    private void setNameInNamespace(Name name) throws NamingException {
        if (this.nameLock && (this.nameInNamespace != null || !this.nameInNamespace.isEmpty())) {
            LOGGER.error("Name already set: name={} nameInNamespace={} this={}", new Object[]{name, this.nameInNamespace, this});
            throw new NamingException("Name already set.");
        }
        this.nameInNamespace = name;
        this.nameLock = true;
    }

    public void forceClose() throws NamingException {
        this.destroySubcontexts(this);
        this.env = null;
        this.namesToObjects = null;
        this.subContexts = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "org/osjava/sj/jndi/MemoryContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "lookup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "bind";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rebind";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "unbind";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "rename";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "list";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "listBindings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

