/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj;

import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.lang.BooleanUtils;
import org.osjava.sj.jndi.MemoryContext;

public class MemoryContextFactory
implements InitialContextFactory {
    private static final ConcurrentHashMap<String, Context> contextsByRoot = new ConcurrentHashMap();

    public Context getInitialContext(Hashtable environment) throws NamingException {
        Boolean isShared = Boolean.valueOf((String)environment.get("org.osjava.sj.jndi.shared"));
        if (!isShared.booleanValue()) {
            return new MemoryContext(environment);
        }
        String root = (String)environment.get("org.osjava.sj.root");
        root = root != null ? root : "";
        Context ctx = contextsByRoot.get(root);
        if (ctx != null) {
            String ignoreClose = (String)environment.get("org.osjava.sj.jndi.ignoreClose");
            ctx.addToEnvironment("org.osjava.sj.jndi.ignoreClose", BooleanUtils.toStringTrueFalse((boolean)BooleanUtils.toBoolean((String)ignoreClose)));
            return ctx;
        }
        final String finalRoot = root;
        MemoryContext context = new MemoryContext(environment){
            private boolean isClosed;

            @Override
            public void close() throws NamingException {
                String ignoreClose;
                if (!this.isClosed && !BooleanUtils.toBoolean((String)(ignoreClose = (String)this.getEnvironment().get("org.osjava.sj.jndi.ignoreClose")))) {
                    contextsByRoot.remove(finalRoot);
                    super.forceClose();
                    this.isClosed = true;
                }
            }
        };
        contextsByRoot.put(root, context);
        return context;
    }

    static void clearCache() {
        contextsByRoot.clear();
    }
}

