/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osjava.sj.loader.NioBasedJndiLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJndi {
    public static final String ROOT = "org.osjava.sj.root";
    public static final String CONTEXT_FACTORY = "org.osjava.sj.factory";
    public static final String ENC = "org.osjava.sj.space";
    public static final String SHARED = "org.osjava.sj.jndi.shared";
    public static final String JNDI_SYNTAX_SEPARATOR = "jndi.syntax.separator";
    private static final Logger logger = LoggerFactory.getLogger(SimpleJndi.class);
    public static final String FILENAME_TO_CONTEXT = "org.osjava.sj.filenameToContext";
    public static final String PATH_SEPARATOR = "org.osjava.sj.pathSeparator";
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleJndi.class);
    private Hashtable<String, String> env;

    SimpleJndi(Hashtable<String, String> environment) {
        this.env = environment;
    }

    InitialContext loadRoot() throws NamingException {
        InitialContext initialContext;
        Context ctxt = initialContext = new InitialContext(this.env);
        ctxt = this.createENC(this.env, ctxt);
        NioBasedJndiLoader loader = new NioBasedJndiLoader(this.env);
        String root = this.getRoot(this.env);
        if (root != null && !root.isEmpty()) {
            String[] roots;
            for (String path : roots = this.extractRoots(root)) {
                String msg;
                if (!path.startsWith("jarMarkerClass=")) {
                    File rootFile = new File(path);
                    LOGGER.debug("Loading {}", (Object)rootFile.getAbsolutePath());
                    try {
                        loader.load(rootFile, ctxt, BooleanUtils.toBoolean((String)this.env.get(FILENAME_TO_CONTEXT)));
                    }
                    catch (Exception e) {
                        String message = "Unable to load: " + rootFile.getAbsolutePath();
                        this.throwException(initialContext, e, message);
                    }
                    continue;
                }
                LOGGER.debug("Processing path={}", (Object)path);
                String[] parts = StringUtils.split((String)path, (String)"=,");
                for (int i = 0; i < parts.length; ++i) {
                    String part = parts[i];
                    LOGGER.debug("Split to: {}", (Object)part);
                }
                URL pathToJar = null;
                try {
                    Class<?> clazz = Class.forName(parts[1]);
                    pathToJar = clazz.getProtectionDomain().getCodeSource().getLocation();
                    File jarFile = new File(pathToJar.toURI());
                    loader.loadJar(jarFile, parts[3], ctxt, BooleanUtils.toBoolean((String)this.env.get(FILENAME_TO_CONTEXT)));
                }
                catch (ClassNotFoundException e) {
                    msg = "Unable to load jarMarkerClass";
                    this.throwException(initialContext, e, msg);
                }
                catch (URISyntaxException e) {
                    msg = "Unable to resolve path to jar file: " + pathToJar;
                    this.throwException(initialContext, e, msg);
                }
                catch (Exception e) {
                    msg = "Unable to load root from jar. jarMarkerClass: " + parts[1] + " root: " + parts[3];
                    this.throwException(initialContext, e, msg);
                }
            }
        } else {
            logger.warn("Mistakenly no root provided?");
        }
        return initialContext;
    }

    private void throwException(InitialContext initialContext, Exception e, String msg) throws NamingException {
        LOGGER.error(msg, (Throwable)e);
        initialContext.close();
        NamingException e2 = new NamingException(msg);
        e2.setRootCause(e);
        throw e2;
    }

    @NotNull
    String[] extractRoots(String root) {
        String pathSeparator = this.env.get(PATH_SEPARATOR);
        return root.split(pathSeparator == null ? File.pathSeparator : pathSeparator);
    }

    private Context createENC(Hashtable env, Context ctxt) throws NamingException {
        String space = (String)env.get(ENC);
        if (space != null) {
            String[] contextNames;
            String delimiter = (String)env.get("org.osjava.sj.delimiter");
            Object separator = env.get(JNDI_SYNTAX_SEPARATOR);
            if (separator != null && !separator.equals(delimiter)) {
                delimiter = "\\" + delimiter + "|\\" + separator;
            }
            for (String name : contextNames = StringUtils.split((String)space, (String)delimiter)) {
                ctxt = ctxt.createSubcontext(name);
            }
        }
        return ctxt;
    }

    @Nullable
    private String getRoot(Hashtable env) {
        String root = (String)env.get(ROOT);
        if (root != null && root.startsWith("file://")) {
            root = root.substring("file://".length());
        }
        return root;
    }
}

