/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osjava.StringUtils;
import org.osjava.sj.jndi.JndiUtils;
import org.osjava.sj.loader.convert.ConverterIF;
import org.osjava.sj.loader.convert.ConverterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiLoader {
    public static final String DELIMITER = "org.osjava.sj.delimiter";
    public static final String COLON_REPLACE = "org.osjava.sj.colon.replace";
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static ConverterRegistry converterRegistry = new ConverterRegistry();
    private final Properties envAsProperties;
    Hashtable environment = new Hashtable();
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final String FILENAME_TO_CONTEXT = "org.osjava.sj.filenameToContext";

    public JndiLoader(Hashtable env) {
        this.environment = new Hashtable(env);
        if (!this.environment.containsKey(DELIMITER)) {
            this.LOGGER.info("{} not set. Setting to \".\"", (Object)DELIMITER);
            this.environment.put(DELIMITER, ".");
        }
        if (!this.environment.containsKey("jndi.syntax.direction")) {
            this.LOGGER.warn("jndi.syntax.direction not set. Setting to \"left_to_right\"");
            this.environment.put("jndi.syntax.direction", "left_to_right");
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.environment);
        this.envAsProperties = props;
    }

    boolean isNotNamespacedTypeDefinition(Properties properties) {
        for (Object k : properties.keySet()) {
            String key = (String)k;
            if (!key.equals("type")) continue;
            return true;
        }
        return false;
    }

    String handleColonReplacement(String name) {
        String colonReplace = (String)this.environment.get(COLON_REPLACE);
        if (colonReplace != null && name.contains(colonReplace)) {
            name = StringUtils.replace(name, colonReplace, ":");
        }
        return name;
    }

    public void load(Properties properties, Context ctxt) throws NamingException {
        this.load(properties, ctxt, null, "");
    }

    void load(Properties properties, Context subContext, Context parentCtxt, String subName) throws NamingException {
        Map<String, Properties> typeMap = this.extractTypedProperties(properties);
        for (String iterator : properties.keySet()) {
            Object value = properties.get(iterator);
            String delimiter = this.extractDelimiter(iterator);
            if (iterator.equals("type") || this.extractTypeDeclaration(iterator) != null) continue;
            if (typeMap.containsKey("datasourceOrBeanProperty")) {
                typeMap.get("datasourceOrBeanProperty").put(iterator, value);
                continue;
            }
            if (typeMap.containsKey(iterator)) {
                typeMap.get(iterator).put("valueToConvert", value);
                continue;
            }
            if (delimiter != null) {
                String pathText = JndiLoader.removeLastElement(iterator, delimiter);
                String nodeText = JndiLoader.getLastElement(iterator, delimiter);
                if (typeMap.containsKey(pathText)) {
                    typeMap.get(pathText).put(nodeText, value);
                    continue;
                }
                this.jndiPut(subContext, iterator, value);
                continue;
            }
            this.jndiPut(subContext, iterator, value);
        }
        Iterator<String> iterator = typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String typeKey = key = iterator.next();
            Properties typeProperties = typeMap.get(typeKey);
            Object value = this.convert(typeProperties);
            if (typeKey.equals("datasourceOrBeanProperty")) {
                parentCtxt.rebind(subName, value);
                continue;
            }
            this.jndiPut(subContext, typeKey, value);
        }
    }

    @NotNull
    Map<String, Properties> extractTypedProperties(Properties properties) throws InvalidNameException {
        HashMap<String, Properties> typeMap = new HashMap<String, Properties>();
        for (String string : properties.keySet()) {
            String type = this.extractTypeDeclaration(string);
            if (!string.equals("type") && type == null) continue;
            Properties props = new Properties();
            props.put("type", properties.get(string));
            if (string.equals("type")) {
                typeMap.put("datasourceOrBeanProperty", props);
                continue;
            }
            String keyWithoutType = string.substring(0, string.length() - type.length() - 1);
            typeMap.put(keyWithoutType, props);
        }
        return typeMap;
    }

    private void processTypedProperty(Properties properties, Context subContext, String subName) throws NamingException {
        Properties notNamespacedKeys;
        Name objName;
        Context deepestCtx;
        if (this.isNotNamespacedTypeDefinition(properties)) {
            String typeDefinition = this.getTypeDefinition(properties);
            Name contextName = this.extractContextName(typeDefinition);
            deepestCtx = subContext;
            if (contextName != null) {
                if (contextName.size() > 1) {
                    contextName.remove(contextName.size() - 1);
                    deepestCtx = this.createSubContexts(contextName, subContext);
                    objName = contextName.getSuffix(contextName.size() - 1);
                } else {
                    objName = contextName;
                }
            } else {
                objName = new CompoundName(subName, EMPTY_PROPERTIES);
            }
            notNamespacedKeys = new Properties();
            for (Object k : properties.keySet()) {
                String key = (String)k;
                key = this.extractObjectName(key);
                String value = (String)properties.get(key);
                notNamespacedKeys.put(key, value);
            }
        } else {
            throw new RuntimeException("Not implemented yet.");
        }
        this.jndiPut(deepestCtx, objName.toString(), this.convert(notNamespacedKeys));
    }

    @Nullable
    String getTypeDefinition(@NotNull Properties properties) {
        for (Object k : properties.keySet()) {
            String key = (String)k;
            if (!key.endsWith("type")) continue;
            return key;
        }
        return null;
    }

    @Nullable
    Name extractContextName(String path) throws InvalidNameException {
        CompoundName name = this.toCompoundName(path);
        Name nameWithoutObjectName = name.size() > 1 ? name.getPrefix(name.size() - 1) : null;
        return nameWithoutObjectName;
    }

    @NotNull
    String extractObjectName(String path) throws InvalidNameException {
        CompoundName name;
        return name.getSuffix((name = this.toCompoundName(path)).size() > 1 ? name.size() - 1 : 0).toString();
    }

    @NotNull
    CompoundName toCompoundName(@NotNull String path) throws InvalidNameException {
        Properties envCopy = new Properties(this.envAsProperties);
        envCopy.setProperty("jndi.syntax.separator", this.envAsProperties.getProperty(DELIMITER));
        envCopy.setProperty("jndi.syntax.direction", (String)this.envAsProperties.get("jndi.syntax.direction"));
        return new CompoundName(path, envCopy);
    }

    private String extractDelimiter(String key) {
        Pattern pattern;
        Matcher matcher;
        String delimiter = (String)this.environment.get(DELIMITER);
        if (delimiter.length() == 1) {
            delimiter = delimiter.replace(".", "\\.");
        }
        if ((matcher = (pattern = Pattern.compile("^.+(" + delimiter + ").+")).matcher(key)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Nullable
    private String extractTypeDeclaration(@NotNull String key) throws InvalidNameException {
        String objName = this.extractObjectName(key);
        return objName.equals("type") ? objName : null;
    }

    private void jndiPut(Context ctxt, String key, Object value) throws NamingException {
        Name name = this.extractContextName(key);
        if (name != null) {
            Context deepestCtx = this.createSubContexts(name, ctxt);
            deepestCtx.bind(this.extractObjectName(key), value);
        } else {
            ctxt.bind(this.toCompoundName(key), value);
        }
    }

    Context createSubContexts(Name name, Context parentContext) throws NamingException {
        Context currentCtx = parentContext;
        for (int i = 0; i < name.size(); ++i) {
            try {
                Object obj = currentCtx.lookup(name.get(i));
                if (!(obj instanceof Context)) {
                    this.LOGGER.error("createSubContexts() CompoundName={} Name '{}' already occupied by '{}'.", new Object[]{name, name.get(i), obj});
                    throw new NotContextException(name.get(i) + " already occupied by " + obj);
                }
                currentCtx = (Context)obj;
                continue;
            }
            catch (NameNotFoundException e) {
                currentCtx = currentCtx.createSubcontext(name.get(i));
            }
        }
        return currentCtx;
    }

    @Nullable
    private Object convert(Properties properties) {
        String type = properties.getProperty("type");
        Object obj = properties.get("valueToConvert");
        String converterClassName = properties.getProperty("converter");
        obj = converterClassName != null ? JndiLoader.callConverter(properties, type, converterClassName) : this.processType(properties, type, obj);
        return obj;
    }

    @Nullable
    Object processType(Properties properties, String type, Object obj) {
        Object o = null;
        if (this.environment.containsKey("java.naming.factory.object")) {
            try {
                Reference reference = JndiUtils.toReference(properties, type);
                o = NamingManager.getObjectInstance(reference, null, null, this.environment);
                o = o == reference ? null : o;
            }
            catch (Exception e) {
                this.LOGGER.error("processType() Exception caught: ", (Throwable)e);
            }
        }
        if (o == null) {
            ConverterIF converter = converterRegistry.getConverter(type);
            if (converter != null) {
                Object values = properties.get("valueToConvert");
                if (values instanceof List) {
                    List vals = (List)values;
                    LinkedList<Object> converted = new LinkedList<Object>();
                    for (String val : vals) {
                        Properties props = new Properties();
                        props.setProperty("valueToConvert", val);
                        converted.add(converter.convert(props, type));
                    }
                    obj = converted;
                } else {
                    obj = converter.convert(properties, type);
                }
            }
        } else {
            obj = o;
        }
        return obj;
    }

    private static Object callConverter(Properties properties, String type, String converterClassName) {
        Object obj;
        try {
            Class<?> converterClass = Class.forName(converterClassName);
            ConverterIF converter = (ConverterIF)converterClass.newInstance();
            obj = converter.convert(properties, type);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Unable to find class: " + converterClassName, cnfe);
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException("Unable to access class: " + type, ie);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Unable to create Converter " + type + " via empty constructor. ", ie);
        }
        return obj;
    }

    private static String getLastElement(String str, String delimiter) {
        int idx = str.lastIndexOf(delimiter);
        return str.substring(idx + 1);
    }

    private static String removeLastElement(String str, String delimiter) {
        int idx = str.lastIndexOf(delimiter);
        return str.substring(0, idx);
    }

    protected boolean isSupportedFile(@NotNull File file) {
        String[] extensionsToProcess = new String[]{"properties", "ini", "xml"};
        String ext = FilenameUtils.getExtension((String)file.getName());
        for (String extToProcess : extensionsToProcess) {
            if (!extToProcess.equals(ext)) continue;
            return true;
        }
        return false;
    }
}

