/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.osjava.sj.loader.OrderedSet;

public class SJProperties
extends Properties {
    private String delimiter = ".";
    protected ArrayList index = new ArrayList();
    private final StrSubstitutor substitutor = new StrSubstitutor(StrLookup.systemPropertiesLookup());

    SJProperties() {
        this((Properties)null);
    }

    SJProperties(Properties defaults) {
        super(defaults);
        this.substitutor.setVariablePrefix("${sj.sys:");
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (value instanceof String) {
            value = this.substitutor.replace(value);
        }
        if (this.index.contains(key)) {
            LinkedList obj = this.get(key);
            if (!(obj instanceof List)) {
                LinkedList list = new LinkedList();
                list.add(obj);
                obj = list;
            }
            ((List)obj).add(value);
            value = obj;
        }
        if (!this.index.contains(key)) {
            this.index.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        this.index.remove(key);
        return super.remove(key);
    }

    public synchronized Enumeration propertyNames() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public synchronized Enumeration keys() {
        return this.propertyNames();
    }

    @Override
    @NotNull
    public synchronized Set keySet() {
        return new OrderedSet(this.index);
    }
}

