/*
 * Decompiled with CFR 0.152.
 */
package com.github.h0tk3y.betterParse.combinators;

import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J+\u0010\u000b\u001a\u00028\u00002\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\u0010\u000eJ+\u0010\u000f\u001a\u00028\u00002\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/github/h0tk3y/betterParse/combinators/Separated;", "T", "S", "", "terms", "", "separators", "(Ljava/util/List;Ljava/util/List;)V", "getSeparators", "()Ljava/util/List;", "getTerms", "reduce", "function", "Lkotlin/Function3;", "(Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "reduceRight", "better-parse"})
public final class Separated<T, S> {
    @NotNull
    private final List<T> terms;
    @NotNull
    private final List<S> separators;

    public Separated(@NotNull List<? extends T> terms, @NotNull List<? extends S> separators) {
        Intrinsics.checkNotNullParameter(terms, (String)"terms");
        Intrinsics.checkNotNullParameter(separators, (String)"separators");
        this.terms = terms;
        this.separators = separators;
        if (!(this.terms.size() == this.separators.size() + 1 || this.terms.isEmpty() && this.separators.isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final List<T> getTerms() {
        return this.terms;
    }

    @NotNull
    public final List<S> getSeparators() {
        return this.separators;
    }

    public final T reduce(@NotNull Function3<? super T, ? super S, ? super T, ? extends T> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        if (this.terms.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object result = CollectionsKt.first(this.terms);
        int n = this.separators.size();
        for (int i = 0; i < n; ++i) {
            result = function.invoke(result, this.separators.get(i), this.terms.get(i + 1));
        }
        return (T)result;
    }

    public final T reduceRight(@NotNull Function3<? super T, ? super S, ? super T, ? extends T> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        if (this.terms.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object result = CollectionsKt.last(this.terms);
        int n = this.separators.size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                result = function.invoke(this.terms.get(i), this.separators.get(i), result);
            } while (0 <= n);
        }
        return (T)result;
    }
}

