/*
 * Decompiled with CFR 0.152.
 */
package com.github.h0tk3y.betterParse.lexer;

import com.github.h0tk3y.betterParse.lexer.Token;
import com.github.h0tk3y.betterParse.lexer.TokenKt;
import com.github.h0tk3y.betterParse.lexer.TokenMatch;
import com.github.h0tk3y.betterParse.lexer.TokenProducer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/h0tk3y/betterParse/lexer/DefaultTokenProducer;", "Lcom/github/h0tk3y/betterParse/lexer/TokenProducer;", "tokens", "", "Lcom/github/h0tk3y/betterParse/lexer/Token;", "input", "", "(Ljava/util/List;Ljava/lang/CharSequence;)V", "col", "", "errorState", "", "inputLength", "pos", "row", "tokenIndex", "nextToken", "Lcom/github/h0tk3y/betterParse/lexer/TokenMatch;", "better-parse"})
final class DefaultTokenProducer
implements TokenProducer {
    @NotNull
    private final List<Token> tokens;
    @NotNull
    private final CharSequence input;
    private final int inputLength;
    private int tokenIndex;
    private int pos;
    private int row;
    private int col;
    private boolean errorState;

    public DefaultTokenProducer(@NotNull List<? extends Token> tokens, @NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.tokens = tokens;
        this.input = input;
        this.inputLength = this.input.length();
        this.row = 1;
        this.col = 1;
    }

    @Override
    @Nullable
    public TokenMatch nextToken() {
        if (this.pos > StringsKt.getLastIndex((CharSequence)this.input) || this.errorState) {
            return null;
        }
        int n = this.tokens.size();
        for (int index = 0; index < n; ++index) {
            Token token2 = this.tokens.get(index);
            int matchLength = token2.match(this.input, this.pos);
            if (matchLength == 0) continue;
            int n2 = this.tokenIndex;
            this.tokenIndex = n2 + 1;
            TokenMatch result = new TokenMatch(token2, n2, this.input, this.pos, matchLength, this.row, this.col);
            int n3 = this.pos + matchLength;
            for (int i = this.pos; i < n3; ++i) {
                int n4;
                if (this.input.charAt(i) == '\n') {
                    n4 = this.row;
                    this.row = n4 + 1;
                    this.col = 1;
                    continue;
                }
                n4 = this.col;
                this.col = n4 + 1;
            }
            this.pos += matchLength;
            return result;
        }
        this.errorState = true;
        int n5 = this.tokenIndex;
        this.tokenIndex = n5 + 1;
        return new TokenMatch(TokenKt.getNoneMatched(), n5, this.input, this.pos, this.inputLength - this.pos, this.row, this.col);
    }
}

