/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CuratorUtils {
    private static final int DEFAULT_RETRY_TIMES = 10;
    private static final int LOG_THRESHOLD = 10;
    private static final int LOG_FREQ = 10;
    private static Logger logger = LoggerFactory.getLogger(CuratorUtils.class);

    private CuratorUtils() {
    }

    public static final void setData(Supplier<CuratorFramework> clientSupplier, String zkPath, Function<byte[], byte[]> updateOperation) {
        CuratorUtils.setData(clientSupplier, zkPath, updateOperation, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setData(Supplier<CuratorFramework> clientSupplier, String zkPath, Function<byte[], byte[]> updateOperation, int maxRetryTimes) {
        int times = 0;
        while (true) {
            try {
                Stat stat = new Stat();
                byte[] forPath = (byte[])((WatchPathable)clientSupplier.get().getData().storingStatIn(stat)).forPath(zkPath);
                if (forPath == null) {
                    throw new RuntimeException("there is no path for:" + zkPath);
                }
                byte[] newData = updateOperation.apply(forPath);
                if (newData == null || Arrays.equals(forPath, newData)) break;
                ((BackgroundPathAndBytesable)clientSupplier.get().setData().withVersion(stat.getVersion())).forPath(zkPath, newData);
                continue;
            }
            catch (Throwable e) {
                logger.error("fail to set data for {}", (Object)zkPath, (Object)e);
            }
            finally {
                if (times++ > 10 && times % 10 == 0) {
                    logger.warn("fail to set data for {} for {} times.", (Object)zkPath, (Object)times);
                }
                if (times <= maxRetryTimes) continue;
                throw new RuntimeException("fail to set data for {}" + zkPath);
                continue;
            }
            break;
        }
    }
}

