/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Collection;
import java.util.Map;

public final class ObjectMapperUtils {
    public static final ObjectMapper mapper = new ObjectMapper();

    public static <T> String toJSON(T obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJSON(String json, Class<T> valueType) {
        try {
            return (T)mapper.readValue(json, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final <T> T value(Object rawValue, Class<T> type) {
        return (T)mapper.convertValue(rawValue, type);
    }

    public static <T> T fromJSON(String json, Class<? extends Collection> collectionType, Class<?> valueType) {
        if (json == null || json.length() == 0) {
            try {
                return (T)collectionType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (T)mapper.readValue(json, (JavaType)TypeFactory.defaultInstance().constructCollectionType(collectionType, valueType));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJSON(String json, Class<? extends Map> mapType, Class<?> keyType, Class<?> valueType) {
        if (json == null || json.length() == 0) {
            try {
                return (T)mapType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (T)mapper.readValue(json, (JavaType)TypeFactory.defaultInstance().constructMapType(mapType, keyType, valueType));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

