/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import java.lang.ref.WeakReference;
import java.util.function.Supplier;

public final class WeakHolder<T> {
    private volatile WeakReference<T> ref;
    private final Supplier<T> supplier;

    private WeakHolder(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static final <T> WeakHolder<T> of(Supplier<T> supplier) {
        return new WeakHolder<T>(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object result;
        if (this.ref == null || (result = this.ref.get()) == null) {
            WeakHolder weakHolder = this;
            synchronized (weakHolder) {
                if (this.ref == null || (result = this.ref.get()) == null) {
                    result = this.supplier.get();
                    this.ref = new WeakReference(result);
                }
            }
        }
        return result;
    }
}

