/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper;

import com.github.phantomthief.zookeeper.AbstractZkBasedNodeResource;
import com.google.common.base.Supplier;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.NodeCache;

public abstract class AbstractLazyZkBasedNodeResource<T>
extends AbstractZkBasedNodeResource<T> {
    protected final String monitorPath;
    private final CuratorFramework client;
    private final Supplier<CuratorFramework> clientFactory;
    private volatile NodeCache cache;

    private AbstractLazyZkBasedNodeResource(String monitorPath, CuratorFramework client, Supplier<CuratorFramework> clientFactory) {
        this.monitorPath = monitorPath;
        this.client = client;
        this.clientFactory = clientFactory;
    }

    public AbstractLazyZkBasedNodeResource(String monitorPath, CuratorFramework client) {
        this(monitorPath, client, null);
    }

    public AbstractLazyZkBasedNodeResource(String monitorPath, Supplier<CuratorFramework> clientFactory) {
        this(monitorPath, null, clientFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodeCache cache() {
        if (this.cache == null) {
            AbstractLazyZkBasedNodeResource abstractLazyZkBasedNodeResource = this;
            synchronized (abstractLazyZkBasedNodeResource) {
                if (this.cache == null) {
                    CuratorFramework thisClient = null;
                    if (this.client != null) {
                        if (this.client.getState() != CuratorFrameworkState.STARTED) {
                            this.client.start();
                        }
                        thisClient = this.client;
                    }
                    if (this.clientFactory != null) {
                        thisClient = (CuratorFramework)this.clientFactory.get();
                    }
                    if (thisClient == null) {
                        throw new RuntimeException("there is no curator framework or client factory found.");
                    }
                    NodeCache buildingCache = new NodeCache(thisClient, this.monitorPath);
                    try {
                        buildingCache.start();
                        buildingCache.rebuild();
                        this.cache = buildingCache;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.cache;
    }
}

