/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper;

import com.github.phantomthief.zookeeper.AbstractZkBasedTreeResource;
import com.google.common.base.Supplier;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;

public abstract class AbstractLazyZkBasedTreeResource<T>
extends AbstractZkBasedTreeResource<T> {
    protected final String monitorPath;
    private final CuratorFramework client;
    private final Supplier<CuratorFramework> clientFactory;
    private volatile PathChildrenCache cache;

    private AbstractLazyZkBasedTreeResource(String monitorPath, CuratorFramework client, Supplier<CuratorFramework> clientFactory) {
        this.monitorPath = monitorPath;
        this.client = client;
        this.clientFactory = clientFactory;
    }

    public AbstractLazyZkBasedTreeResource(String monitorPath, CuratorFramework client) {
        this(monitorPath, client, null);
    }

    public AbstractLazyZkBasedTreeResource(String monitorPath, Supplier<CuratorFramework> clientFactory) {
        this(monitorPath, null, clientFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PathChildrenCache cache() {
        if (this.cache == null) {
            AbstractLazyZkBasedTreeResource abstractLazyZkBasedTreeResource = this;
            synchronized (abstractLazyZkBasedTreeResource) {
                if (this.cache == null) {
                    CuratorFramework thisClient = null;
                    if (this.client != null) {
                        if (this.client.getState() != CuratorFrameworkState.STARTED) {
                            this.client.start();
                        }
                        thisClient = this.client;
                    }
                    if (this.clientFactory != null) {
                        thisClient = (CuratorFramework)this.clientFactory.get();
                    }
                    if (thisClient == null) {
                        throw new RuntimeException("there is no curator framework or client factory found.");
                    }
                    PathChildrenCache buildingCache = new PathChildrenCache(thisClient, this.monitorPath, true);
                    try {
                        buildingCache.start();
                        buildingCache.rebuild();
                        this.cache = buildingCache;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.cache;
    }
}

