/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZkBasedNodeResource<T>
implements Closeable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected volatile T resource;
    private final Object lock = new Object();

    protected abstract T initObject(String var1);

    protected abstract NodeCache cache();

    protected Predicate<T> doCleanupOperation() {
        return null;
    }

    protected long waitStopPeriod() {
        return 0L;
    }

    protected T emptyObject() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T getResource() {
        if (this.resource == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.resource == null) {
                    ChildData currentData = this.cache().getCurrentData();
                    if (currentData == null || currentData.getData() == null) {
                        return this.emptyObject();
                    }
                    this.resource = this.initObject(new String(currentData.getData()));
                    this.cache().getListenable().addListener(() -> {
                        T oldResource = null;
                        Object object = this.lock;
                        synchronized (object) {
                            ChildData data = this.cache().getCurrentData();
                            oldResource = this.resource;
                            this.resource = data != null && data.getData() != null ? this.initObject(new String(data.getData())) : this.emptyObject();
                        }
                        this.cleanup(oldResource);
                    });
                }
            }
        }
        return this.resource;
    }

    protected void cleanup(T oldResource) {
        if (oldResource != null) {
            Predicate<T> doCleanupOperation = this.doCleanupOperation();
            if (doCleanupOperation == null) {
                return;
            }
            Thread cleanupThread = new Thread(() -> {
                do {
                    long waitStopPeriod;
                    if ((waitStopPeriod = this.waitStopPeriod()) <= 0L) continue;
                    try {
                        Thread.sleep(waitStopPeriod);
                    }
                    catch (InterruptedException e) {
                        this.logger.error("Ops.", (Throwable)e);
                    }
                } while (!doCleanupOperation.test(oldResource));
                this.logger.info("successfully close old resource:{}", oldResource);
            }, "old [" + oldResource.getClass().getSimpleName() + "] cleanup thread-[" + oldResource.hashCode() + "]");
            cleanupThread.setUncaughtExceptionHandler((t, e) -> this.logger.error("fail to cleanup resource.", e));
            cleanupThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Predicate<T> cleanOp;
            if (this.resource != null && (cleanOp = this.doCleanupOperation()) != null) {
                cleanOp.test(this.resource);
            }
        }
    }
}

