/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper.datasource;

import com.github.phantomthief.util.ObjectMapperUtils;
import com.github.phantomthief.zookeeper.AbstractLazyZkBasedNodeResource;
import com.google.common.base.Supplier;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.curator.framework.CuratorFramework;

public class ZkBasedBasicDataSource
extends AbstractLazyZkBasedNodeResource<BasicDataSource>
implements DataSource {
    public ZkBasedBasicDataSource(String monitorPath, CuratorFramework client) {
        super(monitorPath, client);
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Ops.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ZkBasedBasicDataSource(String monitorPath, Supplier<CuratorFramework> clientFactory) {
        super(monitorPath, clientFactory);
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Ops.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected BasicDataSource initObject(String rawNode) {
        try {
            Map node = (Map)ObjectMapperUtils.fromJSON(rawNode, Map.class, String.class, Object.class);
            String url = (String)node.get("url");
            String user = (String)node.get("user");
            String pass = (String)node.get("pass");
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setUrl(url);
            dataSource.setUsername(user);
            dataSource.setPassword(pass);
            dataSource.setMinIdle(1);
            dataSource.setMaxIdle(10);
            dataSource.setMaxTotal(-1);
            dataSource.setDefaultAutoCommit(Boolean.valueOf(true));
            dataSource.setMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(1L));
            dataSource.setSoftMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(1L));
            dataSource.setTestOnBorrow(true);
            dataSource.setTestWhileIdle(true);
            dataSource.setValidationQuery("/* ping */");
            BeanUtils.populate((Object)dataSource, (Map)node);
            this.logger.info("build datasource for {}, {}", (Object)this.monitorPath, (Object)url);
            return dataSource;
        }
        catch (Throwable e) {
            this.logger.error("Ops, fail to build dataSource:{}.", (Object)this.monitorPath, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Predicate<BasicDataSource> doCleanupOperation() {
        return oldResource -> {
            if (oldResource.isClosed()) {
                return true;
            }
            try {
                oldResource.close();
                return oldResource.isClosed();
            }
            catch (SQLException e) {
                this.logger.error("fail to close old dataSource:{}", oldResource, (Object)e);
                return false;
            }
        };
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return ((BasicDataSource)this.getResource()).getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        ((BasicDataSource)this.getResource()).setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        ((BasicDataSource)this.getResource()).setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return ((BasicDataSource)this.getResource()).getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return ((BasicDataSource)this.getResource()).getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)((BasicDataSource)this.getResource()).unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return ((BasicDataSource)this.getResource()).isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ((BasicDataSource)this.getResource()).getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return ((BasicDataSource)this.getResource()).getConnection(username, password);
    }
}

